/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.neo4j.function.Predicates;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class CheckPointScheduler
extends LifecycleAdapter {
    static final int MAX_CONSECUTIVE_FAILURES_TOLERANCE = 3;
    private final CheckPointer checkPointer;
    private final IOLimiter ioLimiter;
    private final JobScheduler scheduler;
    private final long recurringPeriodMillis;
    private final DatabaseHealth health;
    private final Throwable[] failures = new Throwable[3];
    private volatile int consecutiveFailures;
    private final Runnable job = new Runnable(){

        @Override
        public void run() {
            try {
                CheckPointScheduler.this.checkPointing = true;
                if (CheckPointScheduler.this.stopped) {
                    return;
                }
                CheckPointScheduler.this.checkPointer.checkPointIfNeeded(new SimpleTriggerInfo("scheduler"));
                if (CheckPointScheduler.this.consecutiveFailures > 0) {
                    Arrays.fill(CheckPointScheduler.this.failures, null);
                    CheckPointScheduler.this.consecutiveFailures = 0;
                }
            }
            catch (Throwable t) {
                ((CheckPointScheduler)CheckPointScheduler.this).failures[((CheckPointScheduler)CheckPointScheduler.this).consecutiveFailures++] = t;
                if (CheckPointScheduler.this.consecutiveFailures >= 3) {
                    UnderlyingStorageException combinedFailure = this.constructCombinedFailure();
                    CheckPointScheduler.this.health.panic(combinedFailure);
                    throw combinedFailure;
                }
            }
            finally {
                CheckPointScheduler.this.checkPointing = false;
            }
            if (!CheckPointScheduler.this.stopped) {
                CheckPointScheduler.this.handle = CheckPointScheduler.this.scheduler.schedule(JobScheduler.Groups.checkPoint, CheckPointScheduler.this.job, CheckPointScheduler.this.recurringPeriodMillis, TimeUnit.MILLISECONDS);
            }
        }

        private UnderlyingStorageException constructCombinedFailure() {
            UnderlyingStorageException combined = new UnderlyingStorageException("Error performing check point");
            for (int i = 0; i < CheckPointScheduler.this.consecutiveFailures; ++i) {
                combined.addSuppressed(CheckPointScheduler.this.failures[i]);
            }
            return combined;
        }
    };
    private volatile JobScheduler.JobHandle handle;
    private volatile boolean stopped;
    private volatile boolean checkPointing;
    private final BooleanSupplier checkPointingCondition = new BooleanSupplier(){

        @Override
        public boolean getAsBoolean() {
            return !CheckPointScheduler.this.checkPointing;
        }
    };

    public CheckPointScheduler(CheckPointer checkPointer, IOLimiter ioLimiter, JobScheduler scheduler, long recurringPeriodMillis, DatabaseHealth health) {
        this.checkPointer = checkPointer;
        this.ioLimiter = ioLimiter;
        this.scheduler = scheduler;
        this.recurringPeriodMillis = recurringPeriodMillis;
        this.health = health;
    }

    public void start() throws Throwable {
        this.handle = this.scheduler.schedule(JobScheduler.Groups.checkPoint, this.job, this.recurringPeriodMillis, TimeUnit.MILLISECONDS);
    }

    public void stop() throws Throwable {
        this.stopped = true;
        if (this.handle != null) {
            this.handle.cancel(false);
        }
        this.waitOngoingCheckpointCompletion();
    }

    private void waitOngoingCheckpointCompletion() {
        this.ioLimiter.disableLimit();
        try {
            Predicates.awaitForever((BooleanSupplier)this.checkPointingCondition, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        finally {
            this.ioLimiter.enableLimit();
        }
    }
}

