/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.RelationshipGroupCache;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class CountGroupsStep
extends ProcessorStep<RelationshipGroupRecord[]> {
    private final RelationshipGroupCache cache;

    public CountGroupsStep(StageControl control, Configuration config, RelationshipGroupCache groupCache) {
        super(control, "COUNT", config, 1, new StatsProvider[0]);
        this.cache = groupCache;
    }

    @Override
    protected void process(RelationshipGroupRecord[] batch, BatchSender sender) throws Throwable {
        for (RelationshipGroupRecord group : batch) {
            this.cache.incrementGroupCount(group.getOwningNode());
        }
    }
}

