/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.hostbased;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Pair;

public interface HostKeyIdentityProvider {
    public Iterable<Pair<KeyPair, List<X509Certificate>>> loadHostKeys();

    public static final class Utils {
        private Utils() {
            throw new UnsupportedOperationException("No instance allowed");
        }

        public static Iterator<Pair<KeyPair, List<X509Certificate>>> iteratorOf(HostKeyIdentityProvider provider) {
            return GenericUtils.iteratorOf(provider == null ? null : provider.loadHostKeys());
        }

        public static HostKeyIdentityProvider wrap(KeyPair ... pairs) {
            return Utils.wrap(GenericUtils.isEmpty(pairs) ? Collections.emptyList() : Arrays.asList(pairs));
        }

        public static HostKeyIdentityProvider wrap(final Iterable<? extends KeyPair> pairs) {
            return new HostKeyIdentityProvider(){

                @Override
                public Iterable<Pair<KeyPair, List<X509Certificate>>> loadHostKeys() {
                    return new Iterable<Pair<KeyPair, List<X509Certificate>>>(){

                        @Override
                        public Iterator<Pair<KeyPair, List<X509Certificate>>> iterator() {
                            final Iterator iter = GenericUtils.iteratorOf(pairs);
                            return new Iterator<Pair<KeyPair, List<X509Certificate>>>(){

                                @Override
                                public boolean hasNext() {
                                    return iter.hasNext();
                                }

                                @Override
                                public Pair<KeyPair, List<X509Certificate>> next() {
                                    KeyPair kp = (KeyPair)iter.next();
                                    return new Pair<KeyPair, List<X509Certificate>>(kp, Collections.emptyList());
                                }

                                @Override
                                public void remove() {
                                    throw new UnsupportedOperationException("No removal allowed");
                                }
                            };
                        }
                    };
                }
            };
        }
    }
}

