/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.password;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Supplier;
import org.apache.sshd.common.util.Transformer;

public interface PasswordIdentityProvider {
    public static final PasswordIdentityProvider EMPTY_PASSWORDS_PROVIDER = new PasswordIdentityProvider(){

        @Override
        public Iterable<String> loadPasswords() {
            return Collections.emptyList();
        }

        public String toString() {
            return "EMPTY";
        }
    };

    public Iterable<String> loadPasswords();

    public static final class Utils {
        public static final Transformer<PasswordIdentityProvider, Iterable<String>> LOADER = new Transformer<PasswordIdentityProvider, Iterable<String>>(){

            @Override
            public Iterable<String> transform(PasswordIdentityProvider p) {
                return p == null ? Collections.emptyList() : p.loadPasswords();
            }
        };

        private Utils() {
            throw new UnsupportedOperationException("No instance allowed");
        }

        public static Iterator<String> iteratorOf(ClientSession session) {
            return session == null ? Collections.emptyIterator() : Utils.iteratorOf(session.getRegisteredIdentities(), session.getPasswordIdentityProvider());
        }

        public static Iterator<String> iteratorOf(PasswordIdentityProvider identities, PasswordIdentityProvider passwords) {
            return Utils.iteratorOf(Utils.resolvePasswordIdentityProvider(identities, passwords));
        }

        public static Iterator<String> iteratorOf(PasswordIdentityProvider provider) {
            return GenericUtils.iteratorOf(provider == null ? null : provider.loadPasswords());
        }

        public static PasswordIdentityProvider resolvePasswordIdentityProvider(PasswordIdentityProvider identities, PasswordIdentityProvider passwords) {
            if (passwords == null || identities == passwords) {
                return identities;
            }
            if (identities == null) {
                return passwords;
            }
            return Utils.multiProvider(identities, passwords);
        }

        public static PasswordIdentityProvider multiProvider(PasswordIdentityProvider ... providers) {
            return GenericUtils.isEmpty(providers) ? EMPTY_PASSWORDS_PROVIDER : Utils.multiProvider(Arrays.asList(providers));
        }

        public static PasswordIdentityProvider multiProvider(Collection<? extends PasswordIdentityProvider> providers) {
            return GenericUtils.isEmpty(providers) ? EMPTY_PASSWORDS_PROVIDER : Utils.wrap(Utils.iterableOf(providers));
        }

        public static Iterable<String> iterableOf(Collection<? extends PasswordIdentityProvider> providers) {
            if (GenericUtils.isEmpty(providers)) {
                return Collections.emptyList();
            }
            ArrayList<2> suppliers = new ArrayList<2>(providers.size());
            for (final PasswordIdentityProvider passwordIdentityProvider : providers) {
                if (passwordIdentityProvider == null) continue;
                suppliers.add(new Supplier<Iterable<String>>(){

                    @Override
                    public Iterable<String> get() {
                        return passwordIdentityProvider.loadPasswords();
                    }
                });
            }
            if (GenericUtils.isEmpty(suppliers)) {
                return Collections.emptyList();
            }
            return GenericUtils.multiIterableSuppliers(suppliers);
        }

        public static PasswordIdentityProvider wrap(String ... passwords) {
            return GenericUtils.isEmpty(passwords) ? EMPTY_PASSWORDS_PROVIDER : Utils.wrap(Arrays.asList(passwords));
        }

        public static PasswordIdentityProvider wrap(final Iterable<String> passwords) {
            return passwords == null ? EMPTY_PASSWORDS_PROVIDER : new PasswordIdentityProvider(){

                @Override
                public Iterable<String> loadPasswords() {
                    return passwords;
                }
            };
        }
    }
}

