/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.hosts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Pair;
import org.apache.sshd.common.util.ValidateUtils;

public abstract class HostPatternsHolder {
    public static final char WILDCARD_PATTERN = '*';
    public static final String ALL_HOSTS_PATTERN = String.valueOf('*');
    public static final char SINGLE_CHAR_PATTERN = '?';
    public static final char NEGATION_CHAR_PATTERN = '!';
    public static final String PATTERN_CHARS = new String(new char[]{'*', '?', '!'});
    private Collection<Pair<Pattern, Boolean>> patterns = new LinkedList<Pair<Pattern, Boolean>>();

    protected HostPatternsHolder() {
    }

    public Collection<Pair<Pattern, Boolean>> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(Collection<Pair<Pattern, Boolean>> patterns) {
        this.patterns = patterns;
    }

    public boolean isHostMatch(String host) {
        return HostPatternsHolder.isHostMatch(host, this.getPatterns());
    }

    public static boolean isSpecificHostPattern(String pattern) {
        if (GenericUtils.isEmpty(pattern)) {
            return false;
        }
        for (int index = 0; index < PATTERN_CHARS.length(); ++index) {
            char ch = PATTERN_CHARS.charAt(index);
            if (pattern.indexOf(ch) < 0) continue;
            return false;
        }
        return true;
    }

    public static List<HostConfigEntry> findMatchingEntries(String host, HostConfigEntry ... entries) {
        if (GenericUtils.isEmpty(host) || GenericUtils.isEmpty(entries)) {
            return Collections.emptyList();
        }
        return HostPatternsHolder.findMatchingEntries(host, Arrays.asList(entries));
    }

    public static List<HostConfigEntry> findMatchingEntries(String host, Collection<? extends HostConfigEntry> entries) {
        if (GenericUtils.isEmpty(host) || GenericUtils.isEmpty(entries)) {
            return Collections.emptyList();
        }
        ArrayList<HostConfigEntry> matches = null;
        for (HostConfigEntry hostConfigEntry : entries) {
            if (!hostConfigEntry.isHostMatch(host)) continue;
            if (matches == null) {
                matches = new ArrayList<HostConfigEntry>(entries.size());
            }
            matches.add(hostConfigEntry);
        }
        if (matches == null) {
            return Collections.emptyList();
        }
        return matches;
    }

    public static boolean isHostMatch(String host, Collection<Pair<Pattern, Boolean>> patterns) {
        if (GenericUtils.isEmpty(patterns)) {
            return false;
        }
        boolean matchFound = false;
        for (Pair<Pattern, Boolean> pp : patterns) {
            Boolean negated = pp.getSecond();
            if (matchFound && !negated.booleanValue() || !HostPatternsHolder.isHostMatch(host, pp.getFirst())) continue;
            if (negated.booleanValue()) {
                return false;
            }
            matchFound = true;
        }
        return matchFound;
    }

    public static boolean isHostMatch(String host, Pattern pattern) {
        if (GenericUtils.isEmpty(host) || pattern == null) {
            return false;
        }
        Matcher m = pattern.matcher(host);
        return m.matches();
    }

    public static List<Pair<Pattern, Boolean>> parsePatterns(CharSequence ... patterns) {
        return HostPatternsHolder.parsePatterns(GenericUtils.isEmpty(patterns) ? Collections.emptyList() : Arrays.asList(patterns));
    }

    public static List<Pair<Pattern, Boolean>> parsePatterns(Collection<? extends CharSequence> patterns) {
        if (GenericUtils.isEmpty(patterns)) {
            return Collections.emptyList();
        }
        ArrayList<Pair<Pattern, Boolean>> result = new ArrayList<Pair<Pattern, Boolean>>(patterns.size());
        for (CharSequence charSequence : patterns) {
            result.add(ValidateUtils.checkNotNull(HostPatternsHolder.toPattern(charSequence), "No pattern for %s", (Object)charSequence));
        }
        return result;
    }

    public static Pair<Pattern, Boolean> toPattern(CharSequence pattern) {
        if (GenericUtils.isEmpty(pattern)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(pattern.length());
        boolean negated = false;
        block6: for (int curPos = 0; curPos < pattern.length(); ++curPos) {
            char ch = pattern.charAt(curPos);
            ValidateUtils.checkTrue(HostPatternsHolder.isValidPatternChar(ch), "Invalid host pattern char in %s", (Object)pattern);
            switch (ch) {
                case '.': {
                    sb.append('\\').append(ch);
                    continue block6;
                }
                case '?': {
                    sb.append('.');
                    continue block6;
                }
                case '*': {
                    sb.append(".*");
                    continue block6;
                }
                case '!': {
                    ValidateUtils.checkTrue(!negated, "Double negation in %s", (Object)pattern);
                    ValidateUtils.checkTrue(curPos == 0, "Negation must be 1st char: %s", (Object)pattern);
                    negated = true;
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return new Pair<Pattern, Boolean>(Pattern.compile(sb.toString(), 2), negated);
    }

    public static boolean isValidPatternChar(char ch) {
        if (ch <= ' ' || ch >= '~') {
            return false;
        }
        if (ch >= 'a' && ch <= 'z') {
            return true;
        }
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        if (ch >= '0' && ch <= '9') {
            return true;
        }
        if ("-_.".indexOf(ch) >= 0) {
            return true;
        }
        return PATTERN_CHARS.indexOf(ch) >= 0;
    }
}

