/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.forward.LocalForwardingEntry;
import org.apache.sshd.common.forward.SocksProxy;
import org.apache.sshd.common.forward.TcpipClientChannel;
import org.apache.sshd.common.forward.TcpipForwarder;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoHandlerFactory;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.server.forward.ForwardingFilter;

public class DefaultTcpipForwarder
extends AbstractInnerCloseable
implements TcpipForwarder,
SessionHolder<Session> {
    public static final String FORWARD_REQUEST_TIMEOUT = "tcpip-forward-request-timeout";
    public static final long DEFAULT_FORWARD_REQUEST_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
    public static final Set<ClientChannelEvent> STATIC_IO_MSG_RECEIVED_EVENTS = Collections.unmodifiableSet(EnumSet.of(ClientChannelEvent.OPENED, ClientChannelEvent.CLOSED));
    private final ConnectionService service;
    private final IoHandlerFactory socksProxyIoHandlerFactory = new IoHandlerFactory(){

        @Override
        public IoHandler create() {
            return new SocksProxy(DefaultTcpipForwarder.this.getConnectionService());
        }
    };
    private final Session sessionInstance;
    private final Map<Integer, SshdSocketAddress> localToRemote = new HashMap<Integer, SshdSocketAddress>();
    private final Map<Integer, SshdSocketAddress> remoteToLocal = new HashMap<Integer, SshdSocketAddress>();
    private final Map<Integer, SocksProxy> dynamicLocal = new HashMap<Integer, SocksProxy>();
    private final Set<LocalForwardingEntry> localForwards = new HashSet<LocalForwardingEntry>();
    private final IoHandlerFactory staticIoHandlerFactory = new IoHandlerFactory(){

        @Override
        public IoHandler create() {
            return new StaticIoHandler();
        }
    };
    private IoAcceptor acceptor;

    public DefaultTcpipForwarder(ConnectionService service) {
        this.service = ValidateUtils.checkNotNull(service, "No connection service");
        this.sessionInstance = ValidateUtils.checkNotNull(service.getSession(), "No session");
    }

    @Override
    public Session getSession() {
        return this.sessionInstance;
    }

    public final ConnectionService getConnectionService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startLocalPortForwarding(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        SshdSocketAddress prev;
        ValidateUtils.checkNotNull(local, "Local address is null");
        ValidateUtils.checkTrue(local.getPort() >= 0, "Invalid local port: %s", (Object)local);
        ValidateUtils.checkNotNull(remote, "Remote address is null");
        if (this.isClosed()) {
            throw new IllegalStateException("TcpipForwarder is closed");
        }
        if (this.isClosing()) {
            throw new IllegalStateException("TcpipForwarder is closing");
        }
        InetSocketAddress bound = this.doBind(local, this.staticIoHandlerFactory);
        int port = bound.getPort();
        Map<Integer, SshdSocketAddress> map = this.localToRemote;
        synchronized (map) {
            prev = this.localToRemote.put(port, remote);
        }
        if (prev != null) {
            throw new IOException("Multiple local port forwarding bindings on port=" + port + ": current=" + remote + ", previous=" + prev);
        }
        SshdSocketAddress result = new SshdSocketAddress(bound.getHostString(), port);
        if (this.log.isDebugEnabled()) {
            this.log.debug("startLocalPortForwarding(" + local + " -> " + remote + "): " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopLocalPortForwarding(SshdSocketAddress local) throws IOException {
        SshdSocketAddress bound;
        ValidateUtils.checkNotNull(local, "Local address is null");
        Map<Integer, SshdSocketAddress> map = this.localToRemote;
        synchronized (map) {
            bound = this.localToRemote.remove(local.getPort());
        }
        if (bound != null && this.acceptor != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("stopLocalPortForwarding(" + local + ") unbind " + bound);
            }
            this.acceptor.unbind(bound.toInetSocketAddress());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("stopLocalPortForwarding(" + local + ") no mapping/acceptor for " + bound);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startRemotePortForwarding(SshdSocketAddress remote, SshdSocketAddress local) throws IOException {
        SshdSocketAddress prev;
        ValidateUtils.checkNotNull(local, "Local address is null");
        ValidateUtils.checkNotNull(remote, "Remote address is null");
        String remoteHost = remote.getHostName();
        int remotePort = remote.getPort();
        Session session = this.getSession();
        Buffer buffer = session.createBuffer((byte)80, remoteHost.length() + 64);
        buffer.putString("tcpip-forward");
        buffer.putBoolean(true);
        buffer.putString(remoteHost);
        buffer.putInt(remotePort);
        long timeout = PropertyResolverUtils.getLongProperty(session, FORWARD_REQUEST_TIMEOUT, DEFAULT_FORWARD_REQUEST_TIMEOUT);
        Buffer result = session.request("tcpip-forward", buffer, timeout, TimeUnit.MILLISECONDS);
        if (result == null) {
            throw new SshException("Tcpip forwarding request denied by server");
        }
        int port = remotePort == 0 ? result.getInt() : remote.getPort();
        Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
        synchronized (map) {
            prev = this.remoteToLocal.put(port, local);
        }
        if (prev != null) {
            throw new IOException("Multiple remote port forwarding bindings on port=" + port + ": current=" + remote + ", previous=" + prev);
        }
        SshdSocketAddress bound = new SshdSocketAddress(remoteHost, port);
        if (this.log.isDebugEnabled()) {
            this.log.debug("startRemotePortForwarding(" + remote + " -> " + local + "): " + bound);
        }
        return bound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopRemotePortForwarding(SshdSocketAddress remote) throws IOException {
        SshdSocketAddress bound;
        Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
        synchronized (map) {
            bound = this.remoteToLocal.remove(remote.getPort());
        }
        if (bound != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("stopRemotePortForwarding(" + remote + ") cancel forwarding to " + bound);
            }
            String remoteHost = remote.getHostName();
            Session session = this.getSession();
            Buffer buffer = session.createBuffer((byte)80, remoteHost.length() + 64);
            buffer.putString("cancel-tcpip-forward");
            buffer.putBoolean(false);
            buffer.putString(remoteHost);
            buffer.putInt(remote.getPort());
            session.writePacket(buffer);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("stopRemotePortForwarding(" + remote + ") no binding found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        SocksProxy prev;
        ValidateUtils.checkNotNull(local, "Local address is null");
        ValidateUtils.checkTrue(local.getPort() >= 0, "Invalid local port: %s", (Object)local);
        if (this.isClosed()) {
            throw new IllegalStateException("TcpipForwarder is closed");
        }
        if (this.isClosing()) {
            throw new IllegalStateException("TcpipForwarder is closing");
        }
        SocksProxy socksProxy = new SocksProxy(this.service);
        InetSocketAddress bound = this.doBind(local, this.socksProxyIoHandlerFactory);
        int port = bound.getPort();
        Map<Integer, SocksProxy> map = this.dynamicLocal;
        synchronized (map) {
            prev = this.dynamicLocal.put(port, socksProxy);
        }
        if (prev != null) {
            throw new IOException("Multiple dynamic port mappings found for port=" + port + ": current=" + socksProxy + ", previous=" + prev);
        }
        SshdSocketAddress result = new SshdSocketAddress(bound.getHostString(), port);
        if (this.log.isDebugEnabled()) {
            this.log.debug("startDynamicPortForwarding(" + local + "): " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        Closeable obj;
        Map<Integer, SocksProxy> map = this.dynamicLocal;
        synchronized (map) {
            obj = this.dynamicLocal.remove(local.getPort());
        }
        if (obj != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("stopDynamicPortForwarding(" + local + ") unbinding");
            }
            obj.close(true);
            this.acceptor.unbind(local.toInetSocketAddress());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("stopDynamicPortForwarding(" + local + ") no binding found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress getForwardedPort(int remotePort) {
        Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
        synchronized (map) {
            return this.remoteToLocal.get(remotePort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress localPortForwardingRequested(SshdSocketAddress local) throws IOException {
        boolean added;
        ValidateUtils.checkNotNull(local, "Local address is null");
        ValidateUtils.checkTrue(local.getPort() >= 0, "Invalid local port: %s", (Object)local);
        Session session = this.getSession();
        FactoryManager manager = ValidateUtils.checkNotNull(session.getFactoryManager(), "No factory manager");
        ForwardingFilter filter = manager.getTcpipForwardingFilter();
        try {
            if (filter == null || !filter.canListen(local, session)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("localPortForwardingRequested(" + session + ")[" + local + "][haveFilter=" + (filter != null) + "] rejected");
                }
                return null;
            }
        }
        catch (Error e) {
            this.log.warn("localPortForwardingRequested({})[{}] failed ({}) to consult forwarding filter: {}", new Object[]{session, local, e.getClass().getSimpleName(), e.getMessage()});
            if (this.log.isDebugEnabled()) {
                this.log.debug("localPortForwardingRequested(" + this + ")[" + local + "] filter consultation failure details", (Throwable)e);
            }
            throw new RuntimeSshException(e);
        }
        InetSocketAddress bound = this.doBind(local, this.staticIoHandlerFactory);
        SshdSocketAddress result = new SshdSocketAddress(bound.getHostString(), bound.getPort());
        if (this.log.isDebugEnabled()) {
            this.log.debug("localPortForwardingRequested(" + local + "): " + result);
        }
        Set<LocalForwardingEntry> set = this.localForwards;
        synchronized (set) {
            added = this.localForwards.add(new LocalForwardingEntry(result.getHostName(), local.getHostName(), result.getPort()));
        }
        if (!added) {
            throw new IOException("Failed to add local port forwarding entry for " + local + " -> " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void localPortForwardingCancelled(SshdSocketAddress local) throws IOException {
        LocalForwardingEntry entry;
        Set<LocalForwardingEntry> set = this.localForwards;
        synchronized (set) {
            entry = LocalForwardingEntry.findMatchingEntry(local.getHostName(), local.getPort(), this.localForwards);
            if (entry != null) {
                this.localForwards.remove(entry);
            }
        }
        if (entry != null && this.acceptor != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("localPortForwardingCancelled(" + local + ") unbind " + entry);
            }
            this.acceptor.unbind(entry.toInetSocketAddress());
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("localPortForwardingCancelled(" + local + ") no match/acceptor: " + entry);
        }
    }

    @Override
    protected synchronized Closeable getInnerCloseable() {
        return this.builder().parallel(this.dynamicLocal.values()).close(this.acceptor).build();
    }

    private InetSocketAddress doBind(SshdSocketAddress address, Factory<? extends IoHandler> handlerFactory) throws IOException {
        Set<SocketAddress> after;
        if (this.acceptor == null) {
            Session session = this.getSession();
            FactoryManager manager = ValidateUtils.checkNotNull(session.getFactoryManager(), "No factory manager");
            IoServiceFactory factory = ValidateUtils.checkNotNull(manager.getIoServiceFactory(), "No I/O service factory");
            IoHandler handler = handlerFactory.create();
            this.acceptor = factory.createAcceptor(handler);
        }
        Set<SocketAddress> before = this.acceptor.getBoundAddresses();
        try {
            InetSocketAddress bindAddress = address.toInetSocketAddress();
            this.acceptor.bind(bindAddress);
            after = this.acceptor.getBoundAddresses();
            if (GenericUtils.size(after) > 0) {
                after.removeAll(before);
            }
            if (GenericUtils.isEmpty(after)) {
                throw new IOException("Error binding to " + address + "[" + bindAddress + "]: no local addresses bound");
            }
            if (after.size() > 1) {
                throw new IOException("Multiple local addresses have been bound for " + address + "[" + bindAddress + "]");
            }
            return (InetSocketAddress)after.iterator().next();
        }
        catch (IOException bindErr) {
            after = this.acceptor.getBoundAddresses();
            if (GenericUtils.isEmpty(after)) {
                this.close();
            }
            throw bindErr;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getSession() + "]";
    }

    class StaticIoHandler
    implements IoHandler {
        StaticIoHandler() {
        }

        @Override
        public void sessionCreated(final IoSession session) throws Exception {
            InetSocketAddress local = (InetSocketAddress)session.getLocalAddress();
            int localPort = local.getPort();
            SshdSocketAddress remote = (SshdSocketAddress)DefaultTcpipForwarder.this.localToRemote.get(localPort);
            if (DefaultTcpipForwarder.this.log.isDebugEnabled()) {
                DefaultTcpipForwarder.this.log.debug("sessionCreated({}) remote={}", (Object)session, (Object)remote);
            }
            final TcpipClientChannel channel = remote != null ? new TcpipClientChannel(TcpipClientChannel.Type.Direct, session, remote) : new TcpipClientChannel(TcpipClientChannel.Type.Forwarded, session, null);
            session.setAttribute(TcpipClientChannel.class, channel);
            DefaultTcpipForwarder.this.service.registerChannel(channel);
            channel.open().addListener(new SshFutureListener<OpenFuture>(){

                @Override
                public void operationComplete(OpenFuture future) {
                    Throwable t = future.getException();
                    if (t != null) {
                        DefaultTcpipForwarder.this.log.warn("Failed ({}) to open channel for session={}: {}", new Object[]{t.getClass().getSimpleName(), session, t.getMessage()});
                        if (DefaultTcpipForwarder.this.log.isDebugEnabled()) {
                            DefaultTcpipForwarder.this.log.debug("sessionCreated(" + session + ") channel=" + channel + " open failure details", t);
                        }
                        DefaultTcpipForwarder.this.service.unregisterChannel(channel);
                        channel.close(false);
                    }
                }
            });
        }

        @Override
        public void sessionClosed(IoSession session) throws Exception {
            TcpipClientChannel channel = (TcpipClientChannel)session.getAttribute(TcpipClientChannel.class);
            if (channel != null) {
                if (DefaultTcpipForwarder.this.log.isDebugEnabled()) {
                    DefaultTcpipForwarder.this.log.debug("sessionClosed({}) closing channel={}", (Object)session, (Object)channel);
                }
                channel.close(false);
            }
        }

        @Override
        public void messageReceived(IoSession session, Readable message) throws Exception {
            TcpipClientChannel channel = (TcpipClientChannel)session.getAttribute(TcpipClientChannel.class);
            ByteArrayBuffer buffer = new ByteArrayBuffer(message.available() + 64, false);
            buffer.putBuffer(message);
            Set<ClientChannelEvent> result = channel.waitFor(STATIC_IO_MSG_RECEIVED_EVENTS, Long.MAX_VALUE);
            if (DefaultTcpipForwarder.this.log.isTraceEnabled()) {
                DefaultTcpipForwarder.this.log.trace("messageReceived({}) channel={}, len={} wait result: {}", new Object[]{session, channel, result, ((Buffer)buffer).array()});
            }
            OutputStream outputStream = channel.getInvertedIn();
            outputStream.write(((Buffer)buffer).array(), ((Buffer)buffer).rpos(), buffer.available());
            outputStream.flush();
        }

        @Override
        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            if (DefaultTcpipForwarder.this.log.isDebugEnabled()) {
                DefaultTcpipForwarder.this.log.debug("exceptionCaught({}) {}: {}", new Object[]{session, cause.getClass().getSimpleName(), cause.getMessage()});
            }
            if (DefaultTcpipForwarder.this.log.isTraceEnabled()) {
                DefaultTcpipForwarder.this.log.trace("exceptionCaught(" + session + ") caught exception details", cause);
            }
            session.close(false);
        }
    }
}

