/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.util.GenericUtils;

public final class NumberUtils {
    public static final List<Class<?>> NUMERIC_PRIMITIVE_CLASSES = Collections.unmodifiableList(Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
    public static final List<Long> POWERS_OF_TWO = Collections.unmodifiableList(new ArrayList<Long>(64){
        private static final long serialVersionUID = 1L;
        {
            long value = 1L;
            int power = 0;
            while (power < 64) {
                this.add(value);
                ++power;
                value <<= 1;
            }
        }
    });

    private NumberUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static boolean isPowerOf2(long value) {
        for (Long l : POWERS_OF_TWO) {
            if (value != l) continue;
            return true;
        }
        return false;
    }

    public static long getNextPowerOf2(long value) {
        long j;
        for (j = 1L; j < value; j <<= 1) {
        }
        return j;
    }

    public static int getNextPowerOf2(int value) {
        int j;
        for (j = 1; j < value; j <<= 1) {
        }
        return j;
    }

    public static int hashCode(long ... values) {
        if (NumberUtils.length(values) <= 0) {
            return 0;
        }
        int hash = NumberUtils.hashCode(values[0]);
        for (int index = 1; index < values.length; ++index) {
            hash += 31 * hash + NumberUtils.hashCode(values[index]);
        }
        return hash;
    }

    public static int hashCode(int ... values) {
        if (NumberUtils.length(values) <= 0) {
            return 0;
        }
        int hash = values[0];
        for (int index = 1; index < values.length; ++index) {
            hash += 31 * hash + values[index];
        }
        return hash;
    }

    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public static boolean isNumericClass(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        return NUMERIC_PRIMITIVE_CLASSES.indexOf(clazz) >= 0;
    }

    public static Integer toInteger(Number n) {
        if (n == null) {
            return null;
        }
        if (n instanceof Integer) {
            return (Integer)n;
        }
        return n.intValue();
    }

    public static String join(CharSequence separator, long ... values) {
        if (NumberUtils.isEmpty(values)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values.length * 8);
        for (long v : values) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(v);
        }
        return sb.toString();
    }

    public static String join(char separator, long ... values) {
        if (NumberUtils.isEmpty(values)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values.length * 8);
        for (long v : values) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(v);
        }
        return sb.toString();
    }

    public static String join(CharSequence separator, boolean unsigned, byte ... values) {
        if (NumberUtils.isEmpty(values)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values.length * 8);
        for (int n : values) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(unsigned ? n & 0xFF : n);
        }
        return sb.toString();
    }

    public static String join(char separator, boolean unsigned, byte ... values) {
        if (NumberUtils.isEmpty(values)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values.length * 8);
        for (int n : values) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(unsigned ? n & 0xFF : n);
        }
        return sb.toString();
    }

    public static String join(CharSequence separator, int ... values) {
        if (NumberUtils.isEmpty(values)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values.length * 8);
        for (int v : values) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(v);
        }
        return sb.toString();
    }

    public static String join(char separator, int ... values) {
        if (NumberUtils.isEmpty(values)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(values.length * 8);
        for (int v : values) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(v);
        }
        return sb.toString();
    }

    public static boolean isEmpty(byte[] a) {
        return NumberUtils.length(a) <= 0;
    }

    public static boolean isEmpty(int[] a) {
        return NumberUtils.length(a) <= 0;
    }

    public static boolean isEmpty(long[] a) {
        return NumberUtils.length(a) <= 0;
    }

    public static int length(byte ... a) {
        return a == null ? 0 : a.length;
    }

    public static int length(int ... a) {
        return a == null ? 0 : a.length;
    }

    public static int length(long ... a) {
        return a == null ? 0 : a.length;
    }

    public static List<Integer> asList(int ... values) {
        int len = NumberUtils.length(values);
        if (len <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> l = new ArrayList<Integer>(len);
        for (int v : values) {
            l.add(v);
        }
        return l;
    }

    public static boolean isIntegerNumber(CharSequence cs) {
        if (GenericUtils.isEmpty(cs)) {
            return false;
        }
        for (int index = 0; index < cs.length(); ++index) {
            char c = cs.charAt(0);
            if (c >= '0' && c <= '9' || (c == '+' || c == '-') && index == 0) continue;
            return false;
        }
        return true;
    }
}

