/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.hostbased;

import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthHostBased
extends AbstractUserAuth
implements SignatureFactoriesManager {
    public static final String NAME = "hostbased";
    private List<NamedFactory<Signature>> factories;

    public UserAuthHostBased() {
        this((List<NamedFactory<Signature>>)null);
    }

    public UserAuthHostBased(List<NamedFactory<Signature>> factories) {
        super(NAME);
        this.factories = factories;
    }

    @Override
    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.factories;
    }

    @Override
    public void setSignatureFactories(List<NamedFactory<Signature>> factories) {
        this.factories = factories;
    }

    @Override
    protected Boolean doAuth(Buffer buffer, boolean init) throws Exception {
        boolean authed;
        HostBasedAuthenticator authenticator;
        ValidateUtils.checkTrue(init, "Instance not initialized");
        int dataLen = buffer.available();
        String username = this.getUsername();
        ServerSession session = this.getSession();
        String keyType = buffer.getString();
        int keyLen = buffer.getInt();
        int keyOffset = buffer.rpos();
        ByteArrayBuffer buf = new ByteArrayBuffer(buffer.array(), keyOffset, keyLen, true);
        PublicKey clientKey = buf.getRawPublicKey();
        List<X509Certificate> certs = Collections.emptyList();
        if (buf.available() > 0) {
            CertificateFactory cf = SecurityUtils.getCertificateFactory("X.509");
            certs = new ArrayList();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(((Buffer)buf).array(), ((Buffer)buf).rpos(), buf.available());){
                X509Certificate c = (X509Certificate)cf.generateCertificate(bais);
                certs.add(c);
            }
        }
        buffer.rpos(keyOffset + keyLen);
        String clientHostName = buffer.getString();
        String clientUsername = buffer.getString();
        byte[] signature = buffer.getBytes();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doAuth({}@{}) authenticate key type={}, fingerprint={}, client={}@{}, num-certs={}", new Object[]{username, session, keyType, KeyUtils.getFingerPrint(clientKey), clientUsername, clientHostName, GenericUtils.size(certs)});
        }
        if ((authenticator = session.getHostBasedAuthenticator()) == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doAuth({}@{}) key type={}, fingerprint={}, client={}@{}, num-certs={} - no authenticator", new Object[]{username, session, keyType, KeyUtils.getFingerPrint(clientKey), clientUsername, clientHostName, GenericUtils.size(certs)});
            }
            return Boolean.FALSE;
        }
        try {
            authed = authenticator.authenticate(session, username, clientKey, clientHostName, clientUsername, certs);
        }
        catch (Error e) {
            this.log.warn("doAuth({}@{}) failed ({}) to consult authenticator for {} key={}: {}", new Object[]{username, session, e.getClass().getSimpleName(), keyType, KeyUtils.getFingerPrint(clientKey), e.getMessage()});
            if (this.log.isDebugEnabled()) {
                this.log.debug("doAuth(" + username + "@" + session + ") delegate consultation failure details", (Throwable)e);
            }
            throw new RuntimeSshException(e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("doAuth({}@{}) key type={}, fingerprint={}, client={}@{}, num-certs={} - authentication result: {}", new Object[]{username, session, keyType, KeyUtils.getFingerPrint(clientKey), clientUsername, clientHostName, GenericUtils.size(certs), authed});
        }
        if (!authed) {
            return Boolean.FALSE;
        }
        List<NamedFactory<Signature>> factories = ValidateUtils.checkNotNullAndNotEmpty(SignatureFactoriesManager.Utils.resolveSignatureFactories(this, session), "No signature factories for session=%s", session);
        Signature verifier = ValidateUtils.checkNotNull(NamedFactory.Utils.create(factories, keyType), "No verifier located for algorithm=%s", (Object)keyType);
        verifier.initVerifier(clientKey);
        byte[] id = session.getSessionId();
        buf = new ByteArrayBuffer(dataLen + id.length + 64, false);
        buf.putBytes(id);
        ((Buffer)buf).putByte((byte)50);
        buf.putString(username);
        buf.putString(this.getService());
        buf.putString(this.getName());
        buf.putString(keyType);
        buf.putInt(keyLen);
        ((Buffer)buf).putRawBytes(buffer.array(), keyOffset, keyLen);
        buf.putString(clientHostName);
        buf.putString(clientUsername);
        if (this.log.isTraceEnabled()) {
            this.log.trace("doAuth({}@{}) key type={}, fingerprint={}, client={}@{}, num-certs={} - verification data: {}", new Object[]{username, session, keyType, KeyUtils.getFingerPrint(clientKey), clientUsername, clientHostName, GenericUtils.size(certs), buf.toHex()});
            this.log.trace("doAuth({}@{}) key type={}, fingerprint={}, client={}@{}, num-certs={} - expected signature: {}", new Object[]{username, session, keyType, KeyUtils.getFingerPrint(clientKey), clientUsername, clientHostName, GenericUtils.size(certs), BufferUtils.toHex(signature)});
        }
        verifier.update(((Buffer)buf).array(), ((Buffer)buf).rpos(), buf.available());
        if (!verifier.verify(signature)) {
            throw new Exception("Key verification failed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("doAuth({}@{}) key type={}, fingerprint={}, client={}@{}, num-certs={} - verified signature", new Object[]{username, session, keyType, KeyUtils.getFingerPrint(clientKey), clientUsername, clientHostName, GenericUtils.size(certs)});
        }
        return Boolean.TRUE;
    }
}

