/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.renjin.compiler.builtins.BuiltinSpecializer;
import org.renjin.compiler.builtins.GenericBuiltinGuard;
import org.renjin.compiler.builtins.LengthSpecializer;
import org.renjin.compiler.builtins.ReplaceSpecializer;
import org.renjin.compiler.builtins.Specializer;
import org.renjin.compiler.ir.exception.InternalCompilerException;
import org.renjin.primitives.Primitives;
import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.repackaged.guava.cache.CacheBuilder;
import org.renjin.repackaged.guava.cache.CacheLoader;
import org.renjin.repackaged.guava.cache.LoadingCache;
import org.renjin.repackaged.guava.collect.Maps;

public class BuiltinSpecializers {
    public static final BuiltinSpecializers INSTANCE = new BuiltinSpecializers();
    private final Map<Primitives.Entry, Specializer> specializers = Maps.newHashMap();
    private final LoadingCache<Primitives.Entry, BuiltinSpecializer> cache;

    public BuiltinSpecializers() {
        this.specializers.put(Primitives.getBuiltinEntry("length"), new GenericBuiltinGuard(new LengthSpecializer()));
        this.specializers.put(Primitives.getBuiltinEntry("[<-"), new GenericBuiltinGuard(new ReplaceSpecializer()));
        this.cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Primitives.Entry, BuiltinSpecializer>(){

            public BuiltinSpecializer load(Primitives.Entry entry) throws Exception {
                return new BuiltinSpecializer(entry);
            }
        });
    }

    public Specializer get(Primitives.Entry primitive2) {
        Preconditions.checkNotNull((Object)primitive2);
        if (this.specializers.containsKey(primitive2)) {
            return this.specializers.get(primitive2);
        }
        try {
            return (Specializer)this.cache.get((Object)primitive2);
        }
        catch (ExecutionException e) {
            throw new InternalCompilerException(e);
        }
    }
}

