/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.renjin.compiler.builtins.DataParallelScalarCall;
import org.renjin.compiler.builtins.DoubleBinaryOp;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.invoke.annotations.PreserveAttributeStyle;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.primitives.Primitives;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.AttributeMap;

public class DataParallelCall
implements Specialization {
    private final String name;
    private final JvmMethod method;
    private List<ValueBounds> argumentTypes;
    private final ValueBounds valueBounds;
    private final Type type;

    public DataParallelCall(Primitives.Entry primitive2, JvmMethod method, List<ValueBounds> argumentTypes) {
        this.name = primitive2.name;
        this.method = method;
        this.argumentTypes = argumentTypes;
        this.valueBounds = this.computeBounds(argumentTypes);
        this.type = this.valueBounds.storageType();
    }

    private ValueBounds computeBounds(List<ValueBounds> argumentBounds) {
        List<ValueBounds> recycledArguments = this.recycledArgumentBounds(argumentBounds);
        ValueBounds bounds = ValueBounds.vector(this.method.getReturnType(), this.computeResultLength(this.argumentTypes));
        if (this.method.getPreserveAttributesStyle() == PreserveAttributeStyle.NONE) {
            bounds = bounds.withAttributes(AttributeMap.EMPTY);
        } else if (bounds.isLengthConstant()) {
            bounds = bounds.withAttributes(this.computeResultAttributes(recycledArguments, bounds.getLength()));
        }
        return bounds;
    }

    private List<ValueBounds> recycledArgumentBounds(List<ValueBounds> argumentBounds) {
        ArrayList list2 = Lists.newArrayList();
        Iterator<ValueBounds> argumentIt = argumentBounds.iterator();
        for (JvmMethod.Argument formal : this.method.getFormals()) {
            if (!formal.isRecycle()) continue;
            list2.add(argumentIt.next());
        }
        return list2;
    }

    private int computeResultLength(List<ValueBounds> argumentBounds) {
        Iterator<ValueBounds> it = argumentBounds.iterator();
        int resultLength = 0;
        while (it.hasNext()) {
            int argumentLength = it.next().getLength();
            if (argumentLength == -1) {
                return -1;
            }
            if (argumentLength == 0) {
                return 0;
            }
            resultLength = Math.max(resultLength, argumentLength);
        }
        return resultLength;
    }

    private AttributeMap computeResultAttributes(List<ValueBounds> argumentBounds, int resultLength) {
        AttributeMap.Builder attributes2 = AttributeMap.newBuilder();
        for (ValueBounds argumentBound : argumentBounds) {
            if (!argumentBound.isAttributeConstant()) {
                return null;
            }
            if (argumentBound.getLength() != resultLength) continue;
            switch (this.method.getPreserveAttributesStyle()) {
                case ALL: {
                    attributes2.combineFrom(argumentBound.getConstantAttributes());
                    break;
                }
                case STRUCTURAL: {
                    attributes2.combineStructuralFrom(argumentBound.getConstantAttributes());
                }
            }
        }
        return attributes2.build();
    }

    public Specialization specializeFurther() {
        if (this.valueBounds.getLength() == 1) {
            DoubleBinaryOp op = DoubleBinaryOp.trySpecialize(this.name, this.method, this.valueBounds);
            if (op != null) {
                return op;
            }
            return new DataParallelScalarCall(this.method, this.argumentTypes, this.valueBounds).trySpecializeFurther();
        }
        return this;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public ValueBounds getValueBounds() {
        return this.valueBounds;
    }

    @Override
    public void load(EmitContext emitContext, InstructionAdapter mv, List<IRArgument> arguments) {
        throw new UnsupportedOperationException();
    }
}

