/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.cfg;

import java.util.Collection;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.cfg.DominanceTree;
import org.renjin.compiler.cfg.UseDefMap;
import org.renjin.compiler.ir.tac.expressions.LValue;
import org.renjin.compiler.ir.tac.statements.Statement;

public class LiveSet {
    private DominanceTree tree;
    private UseDefMap useDefMap;

    public LiveSet(DominanceTree tree, UseDefMap useDefMap) {
        this.tree = tree;
        this.useDefMap = useDefMap;
    }

    public boolean isLiveOut(BasicBlock q, Statement s, LValue a) {
        int i = q.getStatements().indexOf(s) + 1;
        while (i < q.getStatements().size()) {
            if (!this.uses(q.getStatements().get(i), a)) continue;
            return true;
        }
        return this.isLiveOut(q, a);
    }

    public boolean isLiveOut(BasicBlock q, LValue a) {
        BasicBlock def = this.def(a);
        if (def == q) {
            for (BasicBlock use : this.uses(a)) {
                if (use == def) continue;
                return true;
            }
            return false;
        }
        if (this.tree.strictlyDominates(def, q)) {
            throw new UnsupportedOperationException("TODO");
        }
        return false;
    }

    private Collection<BasicBlock> uses(LValue a) {
        return this.useDefMap.getUsedBlocks(a);
    }

    private BasicBlock def(LValue a) {
        return this.useDefMap.getDefinitionBlock(a);
    }

    private boolean uses(Statement statement, LValue a) {
        if (statement.getRHS().equals(a)) {
            return true;
        }
        for (int i = 0; i < statement.getChildCount(); ++i) {
            if (!statement.childAt(i).equals(a)) continue;
            return true;
        }
        return false;
    }
}

