/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.ReadParam;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.repackaged.guava.base.Strings;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Sets;

public class IRBody {
    private Statement[] statements;
    private int[] labels;
    private List<ReadParam> params = Collections.emptyList();

    public IRBody(List<Statement> statements, Map<IRLabel, Integer> labels) {
        this.statements = statements.toArray(new Statement[statements.size()]);
        this.labels = new int[labels.size()];
        Arrays.fill(this.labels, -1);
        for (Map.Entry<IRLabel, Integer> label : labels.entrySet()) {
            this.labels[label.getKey().getIndex()] = label.getValue();
        }
    }

    public List<ReadParam> getParams() {
        return this.params;
    }

    public void setParams(List<ReadParam> params) {
        this.params = params;
    }

    public List<Statement> getStatements() {
        return Lists.newArrayList((Object[])this.statements);
    }

    public int getLabelInstructionIndex(IRLabel label) {
        return this.labels[label.getIndex()];
    }

    public Set<IRLabel> getIntructionLabels(int instructionIndex) {
        HashSet set2 = Sets.newHashSet();
        for (int i = 0; i != this.labels.length; ++i) {
            if (this.labels[i] != instructionIndex) continue;
            set2.add(new IRLabel(i));
        }
        return set2;
    }

    public boolean isLabeled(int instructionIndex) {
        for (int i = 0; i != this.labels.length; ++i) {
            if (this.labels[i] != instructionIndex) continue;
            return true;
        }
        return false;
    }

    private String labelAt(int instructionIndex) {
        Set<IRLabel> labels = this.getIntructionLabels(instructionIndex);
        return labels.isEmpty() ? Strings.repeat((String)" ", (int)5) : Strings.padEnd((String)labels.iterator().next().toString(), (int)5, (char)' ');
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i != this.statements.length; ++i) {
            this.appendLineTo(sb, i);
        }
        return sb.toString();
    }

    public void appendLineTo(StringBuilder sb, int i) {
        sb.append(this.labelAt(i)).append(Strings.padEnd((String)(i + ":"), (int)4, (char)' ')).append(this.statements[i]).append("\n");
    }
}

