/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import java.util.Map;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.SpecializedCallExpression;
import org.renjin.primitives.sequence.IntSequence;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class ElementAccess
extends SpecializedCallExpression {
    private ValueBounds valueBounds = ValueBounds.UNBOUNDED;

    public ElementAccess(Expression vector2, Expression index) {
        super(vector2, index);
    }

    public Expression getVector() {
        return this.arguments[0];
    }

    public Expression getIndex() {
        return this.arguments[1];
    }

    public String toString() {
        return this.getVector() + "[" + this.getIndex() + "]";
    }

    @Override
    public boolean isFunctionDefinitelyPure() {
        return true;
    }

    @Override
    public int load(EmitContext emitContext, InstructionAdapter mv) {
        Expression vector2 = this.getVector();
        Type resultType = this.valueBounds.storageType();
        ValueBounds vectorBounds = vector2.getValueBounds();
        if (vectorBounds.isConstant() && vectorBounds.getConstantValue() instanceof IntSequence) {
            IntSequence sequence = (IntSequence)vectorBounds.getConstantValue();
            this.getIndex().load(emitContext, mv);
            if (sequence.getBy() != 1) {
                mv.iconst(sequence.getBy());
                mv.mul(Type.INT_TYPE);
            }
            if (sequence.getFrom() != 0) {
                mv.iconst(sequence.getFrom());
                mv.add(Type.INT_TYPE);
            }
            return 2;
        }
        if (vector2.getType().getSort() == 10) {
            int stackHeight = vector2.load(emitContext, mv);
            if (vector2.getType().equals((Object)Type.getType(SEXP.class))) {
                mv.checkcast(Type.getType(Vector.class));
            }
            this.getIndex().load(emitContext, mv);
            if (!resultType.equals((Object)Type.INT_TYPE)) {
                throw new UnsupportedOperationException("resultType: " + resultType);
            }
            mv.invokeinterface(Type.getInternalName(Vector.class), "getElementAsInt", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.INT_TYPE}));
            return stackHeight + 1;
        }
        throw new UnsupportedOperationException("vectorType: " + vector2.getType());
    }

    @Override
    public Type getType() {
        return this.valueBounds.storageType();
    }

    @Override
    public ValueBounds updateTypeBounds(Map<Expression, ValueBounds> typeMap) {
        int typeSet = this.getVector().updateTypeBounds(typeMap).getTypeSet();
        this.valueBounds = ValueBounds.primitive(typeSet);
        return this.valueBounds;
    }

    @Override
    public ValueBounds getValueBounds() {
        return this.valueBounds;
    }
}

