/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.functions;

import java.util.List;
import org.renjin.compiler.NotCompilableException;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.compiler.ir.tac.IRBodyBuilder;
import org.renjin.compiler.ir.tac.expressions.BuiltinCall;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.functions.FunctionCallTranslator;
import org.renjin.compiler.ir.tac.functions.TranslationContext;
import org.renjin.compiler.ir.tac.statements.ExprStatement;
import org.renjin.primitives.Primitives;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.PrimitiveFunction;

class BuiltinTranslator
extends FunctionCallTranslator {
    public static final BuiltinTranslator INSTANCE = new BuiltinTranslator();

    BuiltinTranslator() {
    }

    @Override
    public Expression translateToExpression(IRBodyBuilder builder, TranslationContext context, Function resolvedFunction, FunctionCall call2) {
        Primitives.Entry entry = Primitives.getBuiltinEntry(((PrimitiveFunction)resolvedFunction).getName());
        if (entry == null) {
            throw new NotCompilableException(call2);
        }
        List<IRArgument> arguments = builder.translateArgumentList(context, call2.getArguments());
        return new BuiltinCall(builder.getRuntimeState(), call2, entry, arguments);
    }

    @Override
    public Expression translateToSetterExpression(IRBodyBuilder builder, TranslationContext context, Function resolvedFunction, FunctionCall getterCall, Expression rhs) {
        Primitives.Entry entry = Primitives.getBuiltinEntry(((PrimitiveFunction)resolvedFunction).getName());
        if (entry == null) {
            throw new NotCompilableException(getterCall);
        }
        List<IRArgument> arguments = builder.translateArgumentList(context, getterCall.getArguments());
        arguments.add(new IRArgument("value", rhs));
        return new BuiltinCall(builder.getRuntimeState(), getterCall, entry, arguments);
    }

    @Override
    public void addStatement(IRBodyBuilder builder, TranslationContext context, Function resolvedFunction, FunctionCall call2) {
        builder.addStatement(new ExprStatement(this.translateToExpression(builder, context, resolvedFunction, call2)));
    }
}

