/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.pipeline.JitKey;
import org.renjin.primitives.sequence.RepDoubleVector;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.primitives.vector.MemoizedComputation;
import org.renjin.repackaged.guava.base.Joiner;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.Vector;

public class DeferredNode {
    private int id;
    private List<DeferredNode> operands = Lists.newArrayList();
    private Set<DeferredNode> uses = Sets.newIdentityHashSet();
    private Vector vector;

    public DeferredNode(int id, Vector vector2) {
        this.id = id;
        this.vector = vector2 instanceof MemoizedComputation && ((MemoizedComputation)vector2).isCalculated() ? ((MemoizedComputation)vector2).forceResult() : vector2;
    }

    public boolean isComputation() {
        return this.vector instanceof DeferredComputation;
    }

    public DeferredComputation getComputation() {
        return (DeferredComputation)this.vector;
    }

    public void addOperand(DeferredNode node) {
        this.assertNotCircularReference(node);
        this.operands.add(node);
        if (this.vector instanceof RepDoubleVector && this.operands.size() > 3) {
            System.out.println("duplicates added");
        }
    }

    public void addUse(DeferredNode node) {
        this.assertNotCircularReference(node);
        this.uses.add(node);
    }

    private void assertNotCircularReference(DeferredNode node) {
        if (node == this) {
            throw new IllegalArgumentException("Circular reference: " + this.vector.getClass().getName());
        }
    }

    public int getId() {
        return this.id;
    }

    public String getDebugLabel() {
        if (this.vector instanceof DoubleArrayVector) {
            if (this.vector.length() == 1) {
                return Double.toString(this.vector.getElementAsDouble(0));
            }
            return "[" + this.vector.length() + "d]";
        }
        if (this.vector instanceof IntArrayVector) {
            if (this.vector.length() == 1) {
                return Integer.toString(this.vector.getElementAsInt(0));
            }
            return "[" + this.vector.length() + "i]";
        }
        if (this.vector instanceof DeferredComputation) {
            return this.getComputation().getComputationName();
        }
        return this.vector.getClass().getSimpleName();
    }

    public List<DeferredNode> getOperands() {
        return this.operands;
    }

    public String getDebugId() {
        return "N" + this.getId();
    }

    public boolean equivalent(DeferredNode newNode) {
        if (!this.vector.getClass().equals(newNode.vector.getClass())) {
            return false;
        }
        if (this.isComputation()) {
            if (this.getOperands().size() != newNode.getOperands().size()) {
                return false;
            }
            for (int i = 0; i != this.getOperands().size(); ++i) {
                if (this.getOperands().get(i).getId() == newNode.getOperands().get(i).getId()) continue;
                return false;
            }
            return true;
        }
        if (this.vector instanceof IntArrayVector || this.vector instanceof DoubleArrayVector) {
            if (this.vector.length() != newNode.vector.length()) {
                return false;
            }
            if (this.vector.length() > 10) {
                return false;
            }
            for (int i = 0; i != this.vector.length(); ++i) {
                if (this.vector.getVectorType().compareElements(this.vector, i, newNode.vector, i) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.operands.isEmpty()) {
            return this.getDebugLabel();
        }
        return this.getDebugLabel() + "(" + Joiner.on((String)", ").join(this.operands) + ")";
    }

    public Vector getVector() {
        return this.vector;
    }

    public List<DeferredNode> flatten() {
        ArrayList nodes = Lists.newArrayList();
        this.flatten(nodes);
        return nodes;
    }

    public Vector[] flattenVectors() {
        List<DeferredNode> nodes = this.flatten();
        Vector[] vectors = new Vector[nodes.size()];
        for (int i = 0; i != vectors.length; ++i) {
            vectors[i] = nodes.get(i).getVector();
        }
        return vectors;
    }

    public JitKey jitKey() {
        List<DeferredNode> nodes = this.flatten();
        Class[] classes = new Class[nodes.size()];
        for (int i = 0; i != classes.length; ++i) {
            classes[i] = nodes.get(i).getVector().getClass();
        }
        return new JitKey(classes);
    }

    public void setResult(Vector result) {
        this.vector = result;
        for (DeferredNode operand : this.operands) {
            operand.removeUse(this);
        }
        this.operands.clear();
    }

    private void flatten(List<DeferredNode> nodes) {
        nodes.add(this);
        for (DeferredNode operand : this.operands) {
            operand.flatten(nodes);
        }
    }

    public DeferredNode getOperand(int index) {
        return this.getOperands().get(index);
    }

    public void replaceVector(Vector vector2) {
        this.vector = vector2;
    }

    public void replaceOperands(DeferredNode ... operands) {
        this.operands = Lists.newArrayList((Object[])operands);
    }

    public boolean hasValue(double v) {
        return (this.vector instanceof DoubleArrayVector || this.vector instanceof IntArrayVector) && this.vector.length() == 1 && this.vector.getElementAsDouble(0) == v;
    }

    public void replaceOperand(DeferredNode node, DeferredNode replacementValue) {
        for (int i = 0; i != this.operands.size(); ++i) {
            if (this.operands.get(i) != node) continue;
            this.operands.get(i).removeUse(this);
            this.operands.set(i, replacementValue);
            replacementValue.addUse(this);
        }
    }

    public void removeUse(DeferredNode node) {
        this.uses.remove(node);
    }

    public void replaceUse(DeferredNode node, DeferredNode replacementValue) {
        if (this.uses.remove(node)) {
            this.uses.add(replacementValue);
        }
    }

    public boolean isUsed() {
        return !this.uses.isEmpty();
    }

    public boolean isMemoized() {
        return this.isComputation() && this.getComputation() instanceof MemoizedComputation;
    }

    public boolean isComputed() {
        return !(this.vector instanceof DeferredComputation);
    }
}

