/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline.accessor;

import org.renjin.compiler.pipeline.ComputeMethod;
import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.accessor.Accessor;
import org.renjin.compiler.pipeline.accessor.Accessors;
import org.renjin.compiler.pipeline.accessor.InputGraph;
import org.renjin.repackaged.asm.MethodVisitor;

public class TransposingAccessor
extends Accessor {
    private Accessor operandAccessor;
    private Accessor sourceRowCountAccessor;
    private int sourceRowCountLocal;
    private int sourceColCountLocal;

    public TransposingAccessor(DeferredNode node, InputGraph inputGraph) {
        this.operandAccessor = Accessors.create(node.getOperand(0), inputGraph);
        this.sourceRowCountAccessor = Accessors.create(node.getOperand(1), inputGraph);
    }

    @Override
    public void init(ComputeMethod method) {
        this.operandAccessor.init(method);
        this.sourceRowCountAccessor.init(method);
        this.sourceRowCountLocal = method.reserveLocal(1);
        this.sourceColCountLocal = method.reserveLocal(1);
        MethodVisitor mv = method.getVisitor();
        this.operandAccessor.pushLength(method);
        mv.visitInsn(3);
        this.sourceRowCountAccessor.pushInt(method);
        mv.visitInsn(89);
        mv.visitVarInsn(54, this.sourceRowCountLocal);
        mv.visitInsn(108);
        mv.visitVarInsn(54, this.sourceColCountLocal);
    }

    @Override
    public void pushDouble(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        mv.visitInsn(89);
        mv.visitVarInsn(21, this.sourceColCountLocal);
        mv.visitInsn(108);
        mv.visitInsn(95);
        mv.visitVarInsn(21, this.sourceColCountLocal);
        mv.visitInsn(112);
        mv.visitVarInsn(21, this.sourceRowCountLocal);
        mv.visitInsn(104);
        mv.visitInsn(96);
        this.operandAccessor.pushDouble(method);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        this.operandAccessor.pushLength(method);
    }
}

