/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline.accessor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.renjin.compiler.pipeline.ComputeMethod;
import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.accessor.Accessor;
import org.renjin.compiler.pipeline.accessor.Accessors;
import org.renjin.compiler.pipeline.accessor.InputGraph;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.repackaged.asm.Type;
import org.renjin.sexp.Vector;

public class UnaryVectorOpAccessor
extends Accessor {
    private int operandIndex;
    private Accessor operandAccessor;
    private final Class<?> operandType;
    private Method applyMethod;
    private Class<?> returnType;

    public UnaryVectorOpAccessor(DeferredNode node, InputGraph inputGraph) {
        this.operandIndex = inputGraph.getOperandIndex(node);
        this.operandAccessor = Accessors.create(node.getOperands().get(0), inputGraph);
        this.applyMethod = UnaryVectorOpAccessor.findStaticApply(node.getVector());
        assert (this.applyMethod != null);
        this.operandType = this.applyMethod.getParameterTypes()[0];
        this.returnType = this.applyMethod.getReturnType();
    }

    public static boolean accept(DeferredNode node) {
        return UnaryVectorOpAccessor.findStaticApply(node.getVector()) != null;
    }

    private static Method findStaticApply(Vector vector2) {
        for (Method method : vector2.getClass().getMethods()) {
            if (!method.getName().equals("compute") || !Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 1 || !UnaryVectorOpAccessor.supportedType(method.getReturnType()) || !UnaryVectorOpAccessor.supportedType(method.getParameterTypes()[0])) continue;
            return method;
        }
        return null;
    }

    @Override
    public void init(ComputeMethod method) {
        this.operandAccessor.init(method);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        this.operandAccessor.pushLength(method);
    }

    private void push(ComputeMethod method) {
        if (this.operandType.equals(Double.TYPE)) {
            this.operandAccessor.pushDouble(method);
        } else if (this.operandType.equals(Integer.TYPE)) {
            this.operandAccessor.pushInt(method);
        } else {
            throw new UnsupportedOperationException("operandType: " + this.operandType);
        }
        MethodVisitor mv = method.getVisitor();
        mv.visitMethodInsn(184, Type.getInternalName(this.applyMethod.getDeclaringClass()), this.applyMethod.getName(), Type.getMethodDescriptor((Method)this.applyMethod), false);
    }

    @Override
    public void pushDouble(ComputeMethod method) {
        this.push(method);
        if (this.returnType.equals(Integer.TYPE)) {
            method.getVisitor().visitInsn(135);
        } else if (!this.returnType.equals(Double.TYPE)) {
            throw new UnsupportedOperationException("returnType: " + this.returnType);
        }
    }

    @Override
    public void pushInt(ComputeMethod method) {
        this.push(method);
        if (!this.returnType.equals(Integer.TYPE)) {
            if (this.returnType.equals(Double.TYPE)) {
                method.getVisitor().visitInsn(142);
            } else {
                throw new UnsupportedOperationException("returnType: " + this.returnType);
            }
        }
    }
}

