/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline.accessor;

import java.lang.reflect.Modifier;
import java.util.logging.Logger;
import org.renjin.compiler.pipeline.ComputeMethod;
import org.renjin.compiler.pipeline.VectorPipeliner;
import org.renjin.compiler.pipeline.accessor.Accessor;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.sexp.Vector;

public class VirtualAccessor
extends Accessor {
    private static final Logger LOGGER = Logger.getLogger(VirtualAccessor.class.getName());
    private int ptrLocalIndex;
    private String vectorClass;
    private int operandIndex;

    public VirtualAccessor(Vector vector2, int operandIndex) {
        if (VectorPipeliner.DEBUG) {
            System.out.println("VirtualAccessor for " + vector2.getClass().getName());
        }
        if (!Modifier.isPublic(vector2.getClass().getModifiers())) {
            LOGGER.warning("Vector class " + vector2.getClass().getName() + " is not public: member access may not be fully inlined by JVM.");
        }
        this.vectorClass = this.findFirstPublicSuperClass(vector2.getClass()).getName().replace('.', '/');
        this.operandIndex = operandIndex;
    }

    private Class findFirstPublicSuperClass(Class clazz) {
        while (!Modifier.isPublic(clazz.getModifiers())) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    @Override
    public void init(ComputeMethod method) {
        this.ptrLocalIndex = method.reserveLocal(1);
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(25, method.getOperandsLocalIndex());
        this.pushOperandIndex(mv, this.operandIndex);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, this.vectorClass);
        mv.visitVarInsn(58, this.ptrLocalIndex);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(25, this.ptrLocalIndex);
        mv.visitMethodInsn(182, this.vectorClass, "length", "()I", false);
    }

    @Override
    public void pushDouble(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(25, this.ptrLocalIndex);
        mv.visitInsn(95);
        mv.visitMethodInsn(182, this.vectorClass, "getElementAsDouble", "(I)D", false);
    }

    @Override
    public void pushInt(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(25, this.ptrLocalIndex);
        mv.visitInsn(95);
        mv.visitMethodInsn(182, this.vectorClass, "getElementAsInt", "(I)I", false);
    }
}

