/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import java.util.HashMap;
import java.util.Map;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.CollectionUtils;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public class DispatchChain {
    public static final Symbol GENERIC = Symbol.get(".Generic");
    public static final Symbol METHOD = Symbol.get(".Method");
    public static final Symbol CLASS = Symbol.get(".Class");
    public static final Symbol GROUP = Symbol.get(".Group");
    private String generic;
    private String group;
    private String method;
    private Closure closure;
    private Vector classes;
    private final Context context;

    public DispatchChain(Context context) {
        this.context = context;
    }

    public static DispatchChain newChain(Context context, Environment callingEnvironment, String generic, Vector classes) {
        for (int i = 0; i != classes.length(); ++i) {
            Symbol method = Symbol.get(generic + "." + classes.getElementAsString(i));
            SEXP function2 = callingEnvironment.findVariable(context, method, CollectionUtils.IS_FUNCTION, true);
            if (function2 == Symbol.UNBOUND_VALUE) continue;
            DispatchChain chain = new DispatchChain(context);
            chain.classes = classes;
            chain.generic = generic;
            chain.method = method.getPrintName();
            chain.closure = (Closure)function2;
            return chain;
        }
        return null;
    }

    public Map<Symbol, SEXP> createMetadata() {
        HashMap<Symbol, SEXP> metadata = new HashMap<Symbol, SEXP>();
        metadata.put(CLASS, this.classes);
        metadata.put(METHOD, new StringArrayVector(this.method));
        metadata.put(GENERIC, StringVector.valueOf(this.generic));
        if (this.group != null) {
            metadata.put(GROUP, StringVector.valueOf(this.group));
        }
        return metadata;
    }

    public Closure getClosure() {
        return this.closure;
    }

    public DispatchChain withGenericArgument(SEXP sexp) {
        if (sexp instanceof StringVector) {
            this.generic = ((StringVector)sexp).getElementAsString(0);
        }
        return this;
    }

    public DispatchChain withObjectArgument(SEXP sexp) {
        if (sexp != Null.INSTANCE) {
            throw new EvalException("oops, NextMethod(object!=null) is not yet implemented", new Object[0]);
        }
        return this;
    }

    public boolean next() {
        StringVector previous = (StringVector)this.classes;
        if (previous.length() <= 1) {
            this.classes = Null.INSTANCE;
            return false;
        }
        StringVector.Builder newClass = StringVector.newBuilder();
        for (int i = 1; i != previous.length(); ++i) {
            newClass.add(previous.getElementAsString(i));
        }
        newClass.setAttribute(Symbol.get("previous"), (SEXP)previous);
        this.classes = newClass.build();
        return false;
    }

    public Symbol getGenericSymbol() {
        return Symbol.get(this.generic);
    }

    public Symbol getMethodSymbol() {
        return Symbol.get(this.method);
    }
}

