/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.renjin.repackaged.guava.base.Function;
import org.renjin.repackaged.guava.base.Predicate;
import org.renjin.repackaged.guava.collect.Iterables;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Ordering;
import org.renjin.sexp.Closure;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public class Profiler {
    public static boolean ENABLED = Boolean.getBoolean("renjin.profile");
    private static final long MIN_LOOP_TIME_RECORD = TimeUnit.MILLISECONDS.toNanos(500L);
    private static long MATERIALIZATION_TIME = 0L;
    private static long MATERIALIZATION_COUNT = 0L;
    private static Map<Symbol, FunctionProfile> FUNCTION_PROFILES = new IdentityHashMap<Symbol, FunctionProfile>();
    private static Map<Symbol, FunctionProfile> TOP_LEVEL_PROFILES = new IdentityHashMap<Symbol, FunctionProfile>();
    private static List<LoopTiming> LOOP_TIMINGS = new ArrayList<LoopTiming>();
    private static CallTiming CURRENT = null;
    private static LoopTiming CURRENT_LOOP;
    private static long LOOP_TIME;
    private static long startTime;

    public static void reset() {
        FUNCTION_PROFILES.clear();
        startTime = System.nanoTime();
    }

    public static void functionStart(Symbol functionName, char type) {
        CallTiming timing = new CallTiming();
        timing.symbol = functionName;
        timing.parent = Profiler.CURRENT;
        timing.startTime = System.nanoTime();
        timing.type = type;
        CURRENT = timing;
    }

    public static void functionStart(Symbol functionName, org.renjin.sexp.Function functionExpr) {
        if (functionExpr instanceof Closure) {
            Profiler.functionStart(functionName, 'R');
        } else {
            Profiler.functionStart(functionName, 'B');
        }
    }

    public static void loopStart(FunctionCall call2, Vector elements) {
        LoopTiming timing = new LoopTiming();
        timing.call = call2;
        timing.parentCall = CURRENT;
        timing.parent = Profiler.CURRENT_LOOP;
        timing.startTime = System.nanoTime();
        timing.expectedIterations = elements.length();
        CURRENT_LOOP = timing;
    }

    public static void materialized(long time2) {
        MATERIALIZATION_TIME += time2;
        ++MATERIALIZATION_COUNT;
        if (CURRENT != null) {
            CURRENT.materializationTime += time2;
            CURRENT.materializeCount++;
        }
    }

    public static void functionEnd() {
        long endTime = System.nanoTime();
        long time2 = endTime - CURRENT.startTime;
        Profiler.updateMap(FUNCTION_PROFILES, time2);
        if (CURRENT.parent == null) {
            Profiler.updateMap(TOP_LEVEL_PROFILES, time2);
        }
        if ((CURRENT = CURRENT.parent) != null) {
            CURRENT.childTime += time2;
        }
    }

    private static void updateMap(Map<Symbol, FunctionProfile> map, long time2) {
        FunctionProfile profile = map.get(CURRENT.symbol);
        if (profile == null) {
            profile = new FunctionProfile();
            profile.symbol = CURRENT.symbol;
            profile.type = CURRENT.type;
            map.put(profile.symbol, profile);
        }
        profile.time += time2;
        profile.ownTime += time2 - CURRENT.childTime;
        profile.count++;
        profile.bytesAllocated += CURRENT.bytesAllocated;
    }

    public static void loopEnd(int iterations) {
        long endTime = System.nanoTime();
        long time2 = endTime - CURRENT_LOOP.startTime;
        LOOP_TIME += time2;
        if (time2 > MIN_LOOP_TIME_RECORD) {
            CURRENT_LOOP.time = time2;
            CURRENT_LOOP.actualIterations = iterations;
            LOOP_TIMINGS.add(CURRENT_LOOP);
        }
        CURRENT_LOOP = CURRENT_LOOP.parent;
    }

    public static void memoryAllocated(int size, int length2) {
        if (CURRENT != null) {
            CURRENT.bytesAllocated += length2 * (size / 8);
        }
    }

    public static void dumpTotalRunningTime() {
        long totalRunningTime = System.nanoTime() - startTime;
        double seconds = TimeUnit.NANOSECONDS.toSeconds(totalRunningTime);
        double minutes = seconds / 60.0;
        System.out.println("Completed in " + minutes + " minutes");
    }

    public static void dump(PrintStream out) {
        long totalRunningTime = System.nanoTime() - startTime;
        Profiler.printTopFunctions(out, totalRunningTime);
        Profiler.printFunctionTimings(out, totalRunningTime);
        Profiler.printLoopTimings(out);
        Profiler.printMaterializationStats(out);
    }

    private static void printTopFunctions(PrintStream out, final double totalRunningTime) {
        ArrayList profiles = Lists.newArrayList(TOP_LEVEL_PROFILES.values());
        Collections.sort(profiles, Ordering.natural().onResultOf((Function)new Function<FunctionProfile, Long>(){

            public Long apply(FunctionProfile input) {
                return input.time;
            }
        }).reverse());
        Iterables.filter((Iterable)profiles, (Predicate)new Predicate<FunctionProfile>(){

            public boolean apply(FunctionProfile input) {
                return (double)input.time / totalRunningTime > 0.01;
            }
        });
        out.println();
        out.println("TOP-LEVEL FUNCTION CALLS");
        out.println("==================");
        out.println();
        out.println(String.format("  %-25s%10s%10s%10s%4s%10s", "Function", "Count", "Time", "Own Time", "%", "kb Alloc"));
        Profiler.printProfiles(out, totalRunningTime, Iterables.limit((Iterable)profiles, (int)10));
    }

    private static void printFunctionTimings(PrintStream out, double totalRunningTime) {
        ArrayList profiles = Lists.newArrayList(FUNCTION_PROFILES.values());
        Collections.sort(profiles, Ordering.natural().onResultOf((Function)new Function<FunctionProfile, Long>(){

            public Long apply(FunctionProfile input) {
                return input.ownTime;
            }
        }).reverse());
        out.println();
        out.println("FUNCTION CALLS BY OWN TIME");
        out.println("==========================");
        out.println();
        out.println(String.format("  %-25s%10s%10s%10s%4s%10s", "Function", "Count", "Time", "Own Time", "%", "kb Alloc"));
        Profiler.printProfiles(out, totalRunningTime, profiles);
    }

    private static void printProfiles(PrintStream out, double totalRunningTime, Iterable<FunctionProfile> profiles) {
        for (FunctionProfile profile : profiles) {
            out.println(String.format("%c %-25s%10d%10d%10d%3.0f%%%10s", Character.valueOf(profile.type), profile.symbol.getPrintName(), profile.count, TimeUnit.NANOSECONDS.toMillis(profile.time), TimeUnit.NANOSECONDS.toMillis(profile.ownTime), (double)profile.ownTime / totalRunningTime * 100.0, Profiler.formatAlloc(profile.bytesAllocated)));
        }
    }

    private static void printLoopTimings(PrintStream out) {
        out.println();
        out.println("LONG RUNNING LOOPS");
        out.println("==================");
        ArrayList loops = Lists.newArrayList(LOOP_TIMINGS);
        Collections.sort(loops, Ordering.natural().onResultOf((Function)new Function<LoopTiming, Long>(){

            public Long apply(LoopTiming input) {
                return input.time;
            }
        }));
        out.println(String.format("%-25s%10s%10s", "Function", "Iterations", "Time"));
        for (LoopTiming loop : loops) {
            out.println(String.format("%-25s%10d%10d", loop.parentCall.symbol.getPrintName(), loop.actualIterations, TimeUnit.NANOSECONDS.toMillis(loop.time)));
        }
    }

    private static void printMaterializationStats(PrintStream out) {
        out.println();
        out.println("VECTOR PIPELINER");
        out.println("================");
        System.out.println("Materialization count: " + MATERIALIZATION_COUNT);
        System.out.println("Materialization time (ms): " + TimeUnit.NANOSECONDS.toMillis(MATERIALIZATION_TIME));
    }

    private static String formatAlloc(long bytes) {
        if (bytes < 1024L) {
            return "";
        }
        double kb = (double)bytes / 1024.0;
        if (kb < 1024.0) {
            return String.format("%.1f kb", kb);
        }
        double mb = kb / 1024.0;
        if (mb < 1024.0) {
            return String.format("%.1f mb", mb);
        }
        double gb = mb / 1024.0;
        return String.format("%.1f gb", gb);
    }

    static {
        LOOP_TIME = 0L;
        startTime = System.nanoTime();
    }

    private static class LoopTiming {
        private FunctionCall call;
        private long startTime;
        private long time;
        private LoopTiming parent;
        private long expectedIterations;
        private long actualIterations;
        public CallTiming parentCall;

        private LoopTiming() {
        }
    }

    private static class LoopProfile {
        private FunctionCall call;
        private long time;
        private long iterations;

        private LoopProfile() {
        }
    }

    private static class CallTiming {
        private Symbol symbol;
        private char type;
        private CallTiming parent;
        private long startTime;
        private long childTime;
        private long bytesAllocated;
        private long materializationTime;
        private long materializeCount;

        private CallTiming() {
        }
    }

    private static class FunctionProfile {
        private Symbol symbol;
        private long count;
        private long time;
        private long ownTime;
        private long bytesAllocated;
        private char type;

        private FunctionProfile() {
        }
    }
}

