/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.codegen;

import com.sun.codemodel.JArrayCompRef;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JForLoop;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.renjin.invoke.annotations.AllowNull;
import org.renjin.invoke.annotations.PreserveAttributeStyle;
import org.renjin.invoke.codegen.ArgumentException;
import org.renjin.invoke.codegen.DeferredVectorBuilder;
import org.renjin.invoke.codegen.scalars.BooleanType;
import org.renjin.invoke.codegen.scalars.DoubleType;
import org.renjin.invoke.codegen.scalars.IntegerType;
import org.renjin.invoke.codegen.scalars.ScalarType;
import org.renjin.invoke.codegen.scalars.ScalarTypes;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.invoke.model.PrimitiveModel;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Null;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class RecycleLoopBuilder {
    private JCodeModel codeModel;
    private JBlock parent;
    private PrimitiveModel primitive;
    private JvmMethod overload;
    private final JExpression contextVar;
    private List<RecycledArgument> recycledArguments = Lists.newArrayList();
    private Map<JvmMethod.Argument, JExpression> argumentMap = Maps.newHashMap();
    private JVar cycleCount;
    private JVar cycleIndex;
    private ScalarType resultType;
    private boolean useArray;
    private JVar builder;

    public RecycleLoopBuilder(JCodeModel codeModel, JBlock parent2, JExpression contextVar, PrimitiveModel primitive2, JvmMethod overload, Map<JvmMethod.Argument, JExpression> argumentMap) {
        this.codeModel = codeModel;
        this.parent = parent2;
        this.contextVar = contextVar;
        this.primitive = primitive2;
        this.overload = overload;
        this.resultType = ScalarTypes.get(overload.getReturnType());
        for (JvmMethod.Argument argument : overload.getAllArguments()) {
            if (argument.isRecycle()) {
                RecycledArgument recycledArgument = new RecycledArgument(argument, argumentMap.get(argument));
                this.recycledArguments.add(recycledArgument);
                this.argumentMap.put(argument, recycledArgument.getCurrentElementInScalarType());
                continue;
            }
            this.argumentMap.put(argument, argumentMap.get(argument));
        }
        this.useArray = this.recycledArguments.size() <= 2 && (this.resultType instanceof DoubleType || this.resultType instanceof IntegerType || this.resultType instanceof BooleanType);
    }

    public void build() {
        this.computeResultLength();
        this.initializeBuilder();
        this.loop();
        if (!this.useArray) {
            this.copyAttributesUsingBuilder();
        }
        this.parent._return(this.buildResult());
    }

    private void computeResultLength() {
        this.cycleCount = this.parent.decl(this.codeModel._ref(Integer.TYPE), "cycles");
        if (this.recycledArguments.size() == 1) {
            if (this.recycledArguments.get(0).formal.getAnnotation(AllowNull.class) == null) {
                this.parent._if(this.recycledArguments.get(0).sexp.eq((JExpression)this.codeModel.ref(Null.class).staticRef("INSTANCE")))._then()._throw((JExpression)JExpr._new((JClass)this.codeModel.ref(ArgumentException.class)).arg(JExpr.lit((String)"invalid NULL argument to unary function")));
            }
            this.parent.assign((JAssignmentTarget)this.cycleCount, (JExpression)this.recycledArguments.get(0).length);
        } else {
            JConditional zeroLength = this.parent._if(this.anyZeroLength());
            zeroLength._then().assign((JAssignmentTarget)this.cycleCount, JExpr.lit((int)0));
            this.findLongestArgument(zeroLength._else());
        }
        if (this.overload.isDeferrable()) {
            DeferredVectorBuilder deferred = new DeferredVectorBuilder(this.codeModel, this.contextVar, this.primitive, this.overload);
            deferred.buildClass();
            deferred.maybeReturn(this.parent, (JExpression)this.cycleCount, this.deferredArgumentList(), this.copyAttributesFast());
        }
    }

    private void findLongestArgument(JBlock parent2) {
        parent2.assign((JAssignmentTarget)this.cycleCount, JExpr.lit((int)0));
        for (RecycledArgument arg : this.recycledArguments) {
            parent2._if(arg.length.gt((JExpression)this.cycleCount))._then().assign((JAssignmentTarget)this.cycleCount, (JExpression)arg.length);
        }
    }

    private JExpression anyZeroLength() {
        Iterator<RecycledArgument> iterator = this.recycledArguments.iterator();
        JExpression expr = iterator.next().length.eq(JExpr.lit((int)0));
        while (iterator.hasNext()) {
            expr = expr.cor(iterator.next().length.eq(JExpr.lit((int)0)));
        }
        return expr;
    }

    private List<JExpression> deferredArgumentList() {
        for (JvmMethod.Argument arg : this.overload.getAllArguments()) {
            if (arg.isRecycle()) continue;
            throw new UnsupportedOperationException("All arguments of a deferred vector must be @Recycle");
        }
        ArrayList list2 = Lists.newArrayList();
        for (RecycledArgument arg : this.recycledArguments) {
            list2.add(arg.vector);
        }
        return list2;
    }

    private JExpression emptyResult() {
        return this.codeModel.ref(this.resultType.getVectorType()).staticRef("EMPTY");
    }

    private void initializeBuilder() {
        if (this.useArray) {
            JType arrayElementType = this.codeModel._ref(this.resultType.getBuilderArrayElementClass());
            JClass arrayClass = arrayElementType.array();
            this.builder = this.parent.decl((JType)arrayElementType.array(), "array", (JExpression)JExpr.newArray((JType)arrayElementType, (JExpression)this.cycleCount));
        } else {
            JClass builderClass = this.codeModel.ref(this.resultType.getBuilderClass());
            this.builder = this.parent.decl((JType)builderClass, "builder", (JExpression)JExpr._new((JClass)builderClass).arg((JExpression)this.cycleCount));
        }
    }

    private void loop() {
        JForLoop loop = this.parent._for();
        this.cycleIndex = loop.init((JType)this.codeModel.INT, "i", JExpr.lit((int)0));
        loop.test(this.cycleIndex.ne((JExpression)this.cycleCount));
        loop.update(this.cycleIndex.incr());
        this.calculateResult(loop.body());
        this.incrementCounters(loop.body());
    }

    private void calculateResult(JBlock loopBody) {
        for (RecycledArgument recycledArgument : this.recycledArguments) {
            loopBody.assign((JAssignmentTarget)recycledArgument.currentElement, recycledArgument.getCurrentElement());
        }
        if (!this.overload.isPassNA()) {
            JConditional ifNA = loopBody._if(this.isCurrentElementMissing());
            this.assignNA(ifNA._then());
            this.assignCycleResult(ifNA._else());
        } else {
            this.assignCycleResult(loopBody);
        }
    }

    private void incrementCounters(JBlock loopBody) {
        for (RecycledArgument arg : this.recycledArguments) {
            loopBody.assignPlus((JAssignmentTarget)arg.currentElementIndex, JExpr.lit((int)1));
            if (this.recycledArguments.size() <= 1) continue;
            loopBody._if(arg.currentElementIndex.eq((JExpression)arg.length))._then().assign((JAssignmentTarget)arg.currentElementIndex, JExpr.lit((int)0));
        }
    }

    private JExpression isCurrentElementMissing() {
        if (this.recycledArguments.isEmpty()) {
            throw new IllegalStateException(this.overload.getName() + " is marked as @DataParallel, but has no parallel arguments");
        }
        JExpression condition = null;
        for (RecycledArgument arg : this.recycledArguments) {
            if (condition == null) {
                condition = arg.isCurrentElementNA();
                continue;
            }
            condition = condition.cor(arg.isCurrentElementNA());
        }
        return condition;
    }

    private void assignCycleResult(JBlock block) {
        if (this.useArray) {
            JArrayCompRef componentRef = this.builder.component((JExpression)this.cycleIndex);
            block.assign((JAssignmentTarget)componentRef, this.computeCycleResult());
        } else {
            block.add((JStatement)this.builder.invoke("set").arg((JExpression)this.cycleIndex).arg(this.computeCycleResult()));
        }
    }

    private void assignNA(JBlock body2) {
        if (this.useArray) {
            body2.assign((JAssignmentTarget)this.builder.component((JExpression)this.cycleIndex), this.resultType.naLiteral(this.codeModel));
        } else {
            body2.add((JStatement)this.builder.invoke("setNA").arg((JExpression)this.cycleIndex));
        }
    }

    private JExpression computeCycleResult() {
        JInvocation invocation = this.codeModel.ref(this.overload.getDeclaringClass()).staticInvoke(this.overload.getName());
        for (JvmMethod.Argument arg : this.overload.getAllArguments()) {
            if (!this.argumentMap.containsKey(arg)) {
                throw new AssertionError((Object)(arg.getName() + " not present in argumentMap"));
            }
            invocation.arg(this.argumentMap.get(arg));
        }
        if (this.useArray) {
            return this.resultType.toBuildArrayElementType((JExpression)invocation);
        }
        return invocation;
    }

    private void copyAttributesUsingBuilder() {
        if (this.overload.getPreserveAttributesStyle() != PreserveAttributeStyle.NONE) {
            for (RecycledArgument arg : this.recycledArguments) {
                this.parent._if(arg.length.eq((JExpression)this.cycleCount))._then().add(this.copyAttributesFrom(arg));
            }
        }
    }

    private JExpression copyAttributesFast() {
        if (this.overload.getPreserveAttributesStyle() == PreserveAttributeStyle.NONE) {
            return this.codeModel.ref(AttributeMap.class).staticRef("EMPTY");
        }
        if (this.recycledArguments.size() == 1) {
            return this.copyAttributes((JExpression)this.recycledArguments.get(0).vector);
        }
        if (this.recycledArguments.size() == 2) {
            return this.copyAttributes((JExpression)this.recycledArguments.get(0).vector, (JExpression)this.recycledArguments.get(1).vector);
        }
        throw new UnsupportedOperationException("arity = " + this.recycledArguments.size());
    }

    private JStatement copyAttributesFrom(RecycledArgument arg) {
        switch (this.overload.getPreserveAttributesStyle()) {
            case ALL: {
                return this.builder.invoke("combineAttributesFrom").arg((JExpression)arg.vector);
            }
            case STRUCTURAL: {
                return this.builder.invoke("combineStructuralAttributesFrom").arg((JExpression)arg.vector);
            }
        }
        throw new IllegalArgumentException("preserve attribute style: " + (Object)((Object)this.overload.getPreserveAttributesStyle()));
    }

    private JExpression copyAttributes(JExpression arg0, JExpression arg1) {
        String combineMethod;
        switch (this.overload.getPreserveAttributesStyle()) {
            case ALL: {
                combineMethod = "combineAttributes";
                break;
            }
            case STRUCTURAL: {
                combineMethod = "combineStructuralAttributes";
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return this.codeModel.ref(AttributeMap.class).staticInvoke(combineMethod).arg(arg0).arg(arg1);
    }

    private JExpression copyAttributes(JExpression arg) {
        if (this.overload.getPreserveAttributesStyle() == PreserveAttributeStyle.ALL) {
            return arg.invoke("getAttributes");
        }
        if (this.overload.getPreserveAttributesStyle() == PreserveAttributeStyle.STRUCTURAL) {
            return arg.invoke("getAttributes").invoke("copyStructural");
        }
        throw new UnsupportedOperationException();
    }

    private JExpression symbol(String name) {
        return this.codeModel.ref(Symbols.class).staticRef(name);
    }

    private JExpression buildResult() {
        if (this.useArray) {
            return JExpr._new((JClass)this.codeModel.ref(this.resultType.getArrayVectorClass())).arg((JExpression)this.builder).arg(this.copyAttributesFast());
        }
        return this.builder.invoke("build");
    }

    private class RecycledArgument {
        private JvmMethod.Argument formal;
        private ScalarType scalarType;
        private JExpression sexp;
        private JVar vector;
        private JVar length;
        private JVar currentElementIndex;
        private JVar currentElement;

        public RecycledArgument(JvmMethod.Argument argument, JExpression parameter) {
            this.formal = argument;
            this.scalarType = ScalarTypes.get(this.formal.getClazz());
            this.sexp = parameter;
            this.vector = RecycleLoopBuilder.this.parent.decl((JType)RecycleLoopBuilder.this.codeModel.ref(Vector.class), "vector" + this.formal.getIndex(), (JExpression)JExpr.cast((JType)RecycleLoopBuilder.this.codeModel.ref(Vector.class), (JExpression)this.sexp));
            this.length = RecycleLoopBuilder.this.parent.decl(RecycleLoopBuilder.this.codeModel._ref(Integer.TYPE), "length" + this.formal.getIndex(), (JExpression)this.vector.invoke("length"));
            this.currentElementIndex = RecycleLoopBuilder.this.parent.decl(RecycleLoopBuilder.this.codeModel._ref(Integer.TYPE), "currentElementIndex" + this.formal.getIndex(), JExpr.lit((int)0));
            this.currentElement = RecycleLoopBuilder.this.parent.decl(RecycleLoopBuilder.this.codeModel._ref(this.scalarType.getElementStorageType()), "s" + this.formal.getIndex());
        }

        public JType getVectorType() {
            return RecycleLoopBuilder.this.codeModel.ref(this.scalarType.getVectorType());
        }

        public JExpression isCurrentElementNA() {
            return this.scalarType.testNaExpr(RecycleLoopBuilder.this.codeModel, this.currentElement);
        }

        public JExpression getCurrentElement() {
            return this.vector.invoke(this.scalarType.getAccessorMethod()).arg((JExpression)this.currentElementIndex);
        }

        public JExpression getCurrentElementInScalarType() {
            return this.scalarType.fromElementStorageType((JExpression)this.currentElement);
        }
    }
}

