/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection;

import java.util.ArrayList;
import java.util.HashMap;
import org.renjin.eval.Context;
import org.renjin.invoke.codegen.ArgumentIterator;
import org.renjin.invoke.reflection.ConstructorBinding;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.Symbol;

public class ConstructorFunction
extends AbstractSEXP
implements Function {
    private final ConstructorBinding binding;

    public ConstructorFunction(ConstructorBinding binding) {
        this.binding = binding;
    }

    @Override
    public String getTypeName() {
        return "constructor";
    }

    @Override
    public void accept(SexpVisitor visitor) {
    }

    @Override
    public SEXP apply(Context context, Environment rho, FunctionCall call2, PairList args2) {
        ArrayList constructorArgs = Lists.newArrayList();
        HashMap propertyValues = Maps.newHashMap();
        ArgumentIterator argIt = new ArgumentIterator(context, rho, args2);
        while (argIt.hasNext()) {
            PairList.Node node = argIt.nextNode();
            SEXP evaled = context.evaluate(node.getValue(), rho);
            if (node.hasTag()) {
                propertyValues.put(node.getTag(), evaled);
                continue;
            }
            constructorArgs.add(evaled);
        }
        Object instance = this.binding.newInstance(context, constructorArgs);
        if (instance instanceof SEXP) {
            return (SEXP)instance;
        }
        ExternalPtr<Object> externalPtr = new ExternalPtr<Object>(instance);
        for (Symbol propertyName : propertyValues.keySet()) {
            externalPtr.setMember(propertyName, (SEXP)propertyValues.get(propertyName));
        }
        return externalPtr;
    }
}

