/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.renjin.eval.EvalException;
import org.renjin.invoke.reflection.MemberBinding;
import org.renjin.invoke.reflection.converters.Converter;
import org.renjin.invoke.reflection.converters.Converters;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class PropertyBinding
implements MemberBinding {
    private Symbol name;
    private Method getter;
    private Converter getterConverter;
    private List<Setter> setters;

    public PropertyBinding(Symbol name, Method getter, Collection<Method> setters) {
        this.name = name;
        this.getter = getter;
        this.getterConverter = Converters.get(getter.getReturnType());
        this.setters = Lists.newArrayList();
        for (Method setter : setters) {
            this.setters.add(new Setter(setter));
        }
    }

    public Symbol getName() {
        return this.name;
    }

    public Converter getConverter() {
        return this.getterConverter;
    }

    @Override
    public SEXP getValue(Object instance) {
        try {
            return this.getterConverter.convertToR(this.getter.invoke(instance, new Object[0]));
        }
        catch (Exception e) {
            throw new EvalException("Exception thrown while invoking getter '%s' on instance of class '%s'", this.getter.getName(), this.getter.getDeclaringClass().getName());
        }
    }

    public Object getRawValue(Object instance) {
        try {
            return this.getter.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("IllegalAccessException thrown while accessing public member " + this.name, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public void setValue(Object instance, SEXP value) {
        if (this.setters.size() == 0) {
            throw new EvalException("The property '%s' on class '%s' is read-only", this.name, this.getter.getDeclaringClass().getName());
        }
        if (this.setters.size() > 1) {
            throw new EvalException("Overloaded setters are not yet implemented", new Object[0]);
        }
        this.setters.get(0).setValue(instance, value);
    }

    private static class Setter {
        private Method method;
        private Converter converter;

        public Setter(Method method) {
            this.method = method;
            this.converter = Converters.get(method.getParameterTypes()[0]);
        }

        public void setValue(Object instance, SEXP value) {
            Object convertedValue = this.converter.convertToJava(value);
            try {
                this.method.invoke(instance, convertedValue);
            }
            catch (Exception e) {
                throw new EvalException("Exception thrown while calling setter '%s' on instance of class '%s': %s", this.method.getName(), this.method.getDeclaringClass().getName(), e.getMessage());
            }
        }
    }
}

