/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection.converters;

import org.renjin.invoke.reflection.converters.PrimitiveScalarConverter;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class BooleanConverter
extends PrimitiveScalarConverter<Boolean> {
    public static final BooleanConverter INSTANCE = new BooleanConverter();

    public static boolean accept(Class clazz) {
        return clazz == Boolean.TYPE || clazz == Boolean.class;
    }

    public LogicalVector convertToR(Boolean value) {
        if (value == null) {
            return new LogicalArrayVector(LogicalVector.NA);
        }
        return new LogicalArrayVector(value);
    }

    @Override
    public Vector.Type getVectorType() {
        return LogicalVector.VECTOR_TYPE;
    }

    @Override
    protected Object getFirstElement(Vector vector2) {
        return vector2.getElementAsLogical(0) != Logical.FALSE;
    }

    @Override
    public boolean acceptsSEXP(SEXP exp2) {
        return exp2 instanceof LogicalVector;
    }

    @Override
    public int getSpecificity() {
        return 1;
    }
}

