/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection.converters;

import org.renjin.invoke.reflection.converters.PrimitiveScalarConverter;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class IntegerConverter
extends PrimitiveScalarConverter<Number> {
    public static final IntegerConverter INSTANCE = new IntegerConverter();

    private IntegerConverter() {
    }

    @Override
    public SEXP convertToR(Number value) {
        if (value == null) {
            return new IntArrayVector(Integer.MIN_VALUE);
        }
        return new IntArrayVector(value.intValue());
    }

    public static boolean accept(Class clazz) {
        return clazz == Integer.TYPE || clazz == Integer.class || clazz == Short.TYPE || clazz == Short.class;
    }

    @Override
    public Vector.Type getVectorType() {
        return IntVector.VECTOR_TYPE;
    }

    @Override
    protected Object getFirstElement(Vector value) {
        return value.getElementAsInt(0);
    }

    @Override
    public boolean acceptsSEXP(SEXP exp2) {
        return exp2 instanceof IntVector;
    }

    @Override
    public int getSpecificity() {
        return 2;
    }
}

