/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.packaging;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.renjin.eval.Context;
import org.renjin.packaging.SerializedPromise;
import org.renjin.packaging.SerializedPromise1;
import org.renjin.primitives.io.serialization.RDataReader;
import org.renjin.repackaged.guava.base.Function;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.SEXP;

public class LazyLoadFrame {
    private static final int OLD_VERSION = 1;
    private static final int VERSION = 2;

    public static Iterable<NamedValue> load(Context context, Function<String, InputStream> resourceProvider) throws IOException {
        DataInputStream din = new DataInputStream((InputStream)resourceProvider.apply((Object)"environment"));
        int version = din.readInt();
        if (version == 1) {
            return LazyLoadFrame.readOldVersion(din);
        }
        if (version != 2) {
            throw new IOException("Unsupported version: " + version);
        }
        int count = din.readInt();
        ListVector.NamedBuilder vector2 = new ListVector.NamedBuilder(0, count);
        for (int i = 0; i != count; ++i) {
            String name = din.readUTF();
            int length2 = din.readInt();
            if (length2 < 0) {
                vector2.add(name, (SEXP)new SerializedPromise(resourceProvider, name));
                continue;
            }
            byte[] serialized = new byte[length2];
            din.readFully(serialized);
            RDataReader reader = new RDataReader(context, new ByteArrayInputStream(serialized));
            vector2.add(name, reader.readFile());
        }
        din.close();
        return vector2.build().namedValues();
    }

    private static Iterable<NamedValue> readOldVersion(DataInputStream din) throws IOException {
        int count = din.readInt();
        ListVector.NamedBuilder vector2 = new ListVector.NamedBuilder(0, count);
        for (int i = 0; i != count; ++i) {
            String name = din.readUTF();
            int byteCount = din.readInt();
            byte[] bytes = new byte[byteCount];
            din.readFully(bytes);
            vector2.add(name, (SEXP)new SerializedPromise1(bytes));
        }
        din.close();
        return vector2.build().namedValues();
    }
}

