/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.logging.Logger;
import org.apache.commons.math.complex.Complex;
import org.renjin.parser.LexerContextStack;
import org.renjin.parser.NumericLiterals;
import org.renjin.parser.ParseOptions;
import org.renjin.parser.ParseState;
import org.renjin.parser.Position;
import org.renjin.parser.RLexException;
import org.renjin.parser.RLexerReader;
import org.renjin.parser.RParser;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ComplexArrayVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.util.CDefines;

public class RLexer
implements RParser.Lexer {
    public static int R_ParseContextLine = 0;
    private static Logger logger = Logger.getLogger("R.Lexer");
    private int savedToken;
    private SEXP savedLVal;
    private Position savedTokenPos = null;
    private SEXP yylval;
    private final ParseState parseState;
    private final ParseOptions parseOptions;
    private Position tokenBegin = new Position();
    private Position tokenEnd = new Position();
    private RLexerReader reader;
    private final LexerContextStack contextStack = new LexerContextStack();
    private Keyword[] keywords = new Keyword[]{new Keyword("NULL", 262), new Keyword("NA", 261), new Keyword("TRUE", 261), new Keyword("FALSE", 261), new Keyword("Inf", 261), new Keyword("NaN", 261), new Keyword("NA_integer_", 261), new Keyword("NA_real_", 261), new Keyword("NA_character_", 261), new Keyword("NA_complex_", 261), new Keyword("function", 264), new Keyword("while", 273), new Keyword("repeat", 276), new Keyword("for", 269), new Keyword("if", 271), new Keyword("in", 270), new Keyword("else", 272), new Keyword("next", 274), new Keyword("break", 275), new Keyword("...", 263)};
    private RParser.Location errorLocation;
    private String errorMessage;

    public RLexer(ParseOptions options2, ParseState state, Reader reader) {
        this.reader = new RLexerReader(reader);
        this.parseOptions = options2;
        this.parseState = state;
    }

    @Override
    public Position getStartPos() {
        return this.tokenBegin.clone();
    }

    @Override
    public Position getEndPos() {
        return this.tokenEnd.clone();
    }

    @Override
    public SEXP getLVal() {
        return this.yylval;
    }

    @Override
    public int yylex() {
        int token;
        while ((token = this.consumeNextToken()) == 10) {
            if (this.parseState.getEatLines() || this.contextStack.peek() == '[' || this.contextStack.peek() == '(') continue;
            if (this.contextStack.peek() == 'i') {
                while (token == 10) {
                    token = this.consumeNextToken();
                }
                if (token == 125 || token == 41 || token == 93) {
                    while (this.contextStack.peek() == 'i') {
                        this.contextStack.ifPop();
                    }
                    this.contextStack.pop();
                    this.setlastloc();
                    return token;
                }
                if (token == 44) {
                    this.contextStack.ifPop();
                    this.setlastloc();
                    return token;
                }
                if (token == 272) {
                    this.parseState.setEatLines(true);
                    this.contextStack.ifPop();
                    this.setlastloc();
                    return 272;
                }
                this.contextStack.ifPop();
                this.savedToken = token;
                this.savedTokenPos = this.tokenBegin.clone();
                this.savedLVal = this.yylval;
                this.setlastloc();
                return 10;
            }
            this.setlastloc();
            return 10;
        }
        switch (token) {
            case 33: 
            case 36: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 58: 
            case 61: 
            case 63: 
            case 64: 
            case 94: 
            case 126: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 269: 
            case 270: 
            case 273: 
            case 276: 
            case 277: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 293: {
                this.parseState.setEatLines(true);
                break;
            }
            case 271: {
                this.contextStack.ifPush();
                this.parseState.setEatLines(false);
                break;
            }
            case 272: {
                this.contextStack.ifPop();
                this.parseState.setEatLines(true);
                break;
            }
            case 44: 
            case 59: {
                this.contextStack.ifPop();
                break;
            }
            case 260: 
            case 261: 
            case 262: 
            case 263: 
            case 274: 
            case 275: {
                this.parseState.setEatLines(false);
                break;
            }
            case 268: {
                this.contextStack.push('[');
                this.contextStack.push('[');
                break;
            }
            case 91: {
                this.contextStack.push((char)token);
                break;
            }
            case 123: {
                this.contextStack.push(token);
                this.parseState.setEatLines(true);
                break;
            }
            case 40: {
                this.contextStack.push(token);
                break;
            }
            case 93: {
                while (this.contextStack.peek() == 'i') {
                    this.contextStack.ifPop();
                }
                this.contextStack.pop();
                this.parseState.setEatLines(false);
                break;
            }
            case 125: {
                while (this.contextStack.peek() == 'i') {
                    this.contextStack.ifPop();
                }
                this.contextStack.pop();
                break;
            }
            case 41: {
                while (this.contextStack.peek() == 'i') {
                    this.contextStack.ifPop();
                }
                this.contextStack.pop();
                this.parseState.setEatLines(false);
            }
        }
        this.setlastloc();
        return token;
    }

    private int consumeNextToken() {
        if (this.savedToken != 0) {
            int c2 = this.savedToken;
            this.yylval = this.savedLVal;
            this.savedLVal = Null.INSTANCE;
            this.savedToken = 0;
            this.tokenBegin = this.savedTokenPos;
            return c2;
        }
        int c3 = this.skipSpace();
        if (c3 == 35) {
            c3 = this.skipComment();
        }
        this.tokenBegin.line = this.reader.getLineNumber();
        this.tokenBegin.column = this.reader.getColumnNumber();
        this.tokenBegin.charIndex = this.reader.getCharacterIndex();
        if (c3 == -1) {
            return 258;
        }
        if (c3 == 46 && this.typeofnext() >= 2) {
            return this.consumeSymbolValue(c3);
        }
        if (c3 == 46) {
            return this.consumeNumericValue(c3);
        }
        if (Character.isDigit(c3)) {
            return this.consumeNumericValue(c3);
        }
        if (c3 == 34 || c3 == 39) {
            return this.consumeStringValue(c3, false);
        }
        if (c3 == 37) {
            return this.consumeSpecialValue(c3);
        }
        if (c3 == 96) {
            return this.consumeStringValue(c3, true);
        }
        if (Character.isLetter(c3)) {
            return this.consumeSymbolValue(c3);
        }
        switch (c3) {
            case 60: {
                if (this.isNextChar(61)) {
                    this.yylval = Symbol.get("<=");
                    return 280;
                }
                if (this.isNextChar(45)) {
                    this.yylval = Symbol.get("<-");
                    return 265;
                }
                if (this.isNextChar(60)) {
                    if (this.isNextChar(45)) {
                        this.yylval = Symbol.get("<<-");
                        return 265;
                    }
                    return 259;
                }
                this.yylval = Symbol.get("<");
                return 279;
            }
            case 45: {
                if (this.isNextChar(62)) {
                    if (this.isNextChar(62)) {
                        this.yylval = Symbol.get("<<-");
                        return 267;
                    }
                    this.yylval = Symbol.get("<-");
                    return 267;
                }
                this.yylval = Symbol.get("-");
                return 45;
            }
            case 62: {
                if (this.isNextChar(61)) {
                    this.yylval = Symbol.get(">=");
                    return 278;
                }
                this.yylval = Symbol.get(">");
                return 277;
            }
            case 33: {
                if (this.isNextChar(61)) {
                    this.yylval = Symbol.get("!=");
                    return 282;
                }
                this.yylval = Symbol.get("!");
                return 33;
            }
            case 61: {
                if (this.isNextChar(61)) {
                    this.yylval = Symbol.get("==");
                    return 281;
                }
                this.yylval = Symbol.get("=");
                return 266;
            }
            case 58: {
                if (this.isNextChar(58)) {
                    if (this.isNextChar(58)) {
                        this.yylval = Symbol.get(":::");
                        return 288;
                    }
                    this.yylval = Symbol.get("::");
                    return 287;
                }
                if (this.isNextChar(61)) {
                    this.yylval = Symbol.get(":=");
                    return 265;
                }
                this.yylval = Symbol.get(":");
                return 58;
            }
            case 38: {
                if (this.isNextChar(38)) {
                    this.yylval = Symbol.get("&&");
                    return 285;
                }
                this.yylval = Symbol.get("&");
                return 283;
            }
            case 124: {
                if (this.isNextChar(124)) {
                    this.yylval = Symbol.get("||");
                    return 286;
                }
                this.yylval = Symbol.get("|");
                return 284;
            }
            case 123: {
                this.yylval = Symbol.get("{");
                return c3;
            }
            case 125: {
                return c3;
            }
            case 40: {
                this.yylval = Symbol.get("(");
                return c3;
            }
            case 41: {
                return c3;
            }
            case 91: {
                if (this.isNextChar(91)) {
                    this.yylval = Symbol.get("[[");
                    return 268;
                }
                this.yylval = Symbol.get("[");
                return c3;
            }
            case 93: {
                return c3;
            }
            case 63: {
                this.yylval = Symbol.get("?");
                return c3;
            }
            case 42: {
                if (this.isNextChar(42)) {
                    c3 = 94;
                }
                this.yylval = Symbol.get(this.codePointToString(c3));
                return c3;
            }
            case 36: 
            case 43: 
            case 47: 
            case 64: 
            case 94: 
            case 126: {
                this.yylval = Symbol.get(this.codePointToString(c3));
                return c3;
            }
        }
        return c3;
    }

    private String codePointToString(int c2) {
        return new String(new int[]{c2}, 0, 1);
    }

    private int typeofnext() {
        int c2 = this.xxgetc();
        int k = Character.isDigit(c2) ? 1 : 2;
        this.xxungetc(c2);
        return k;
    }

    private boolean isNextChar(int expect) {
        int c2 = this.xxgetc();
        if (c2 == expect) {
            return true;
        }
        this.xxungetc(c2);
        return false;
    }

    @Override
    public void yyerror(RParser.Location loc, String s) {
        this.errorLocation = loc;
        this.errorMessage = s;
    }

    public boolean errorEncountered() {
        return this.errorLocation != null;
    }

    public RParser.Location getErrorLocation() {
        return this.errorLocation;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    void setlastloc() {
        this.tokenEnd.line = this.reader.getLineNumber();
        this.tokenEnd.column = this.reader.getColumnNumber();
        this.tokenEnd.charIndex = this.reader.getCharacterIndex();
    }

    private int skipComment() {
        boolean maybeLine;
        char c2 = '#';
        boolean bl = maybeLine = this.reader.getColumnNumber() == 1;
        if (maybeLine) {
            String lineDirective = "#line";
            for (int i = 1; i < 5; ++i) {
                c2 = this.xxgetc();
                if (c2 == lineDirective.charAt(i)) continue;
                maybeLine = false;
                break;
            }
            if (maybeLine) {
                c2 = this.processLineDirective();
            }
        }
        while (c2 != '\n' && c2 != '\uffffffff') {
            c2 = this.xxgetc();
        }
        return c2;
    }

    private int xxgetc() {
        int c2;
        try {
            c2 = this.reader.read();
            if (c2 == 13 && (c2 = this.reader.read()) != 10) {
                this.reader.unread(c2);
                c2 = 10;
            }
        }
        catch (IOException e) {
            throw new RLexException(e);
        }
        if (c2 == -1) {
            return -1;
        }
        R_ParseContextLine = this.reader.getLineNumber();
        if (this.parseOptions.isKeepSource() && this.parseOptions.isGenerateCode()) {
            this.parseState.getFunctionSource().maybeAppendSourceCodePoint(c2);
        }
        return c2;
    }

    private int processLineDirective() {
        int c2 = this.skipSpace();
        if (!Character.isDigit(c2)) {
            return c2;
        }
        int tok = this.consumeNumericValue(c2);
        int linenumber = this.parseOptions.isGenerateCode() ? (int)this.yylval.asReal() : 0;
        c2 = this.skipSpace();
        if (c2 == 34) {
            tok = this.consumeStringValue(c2, false);
        }
        if (tok == 260) {
            this.setParseFilename(this.yylval);
        }
        while ((c2 = this.xxgetc()) != 10 && c2 != -1) {
        }
        this.reader.setLineNumber(linenumber);
        return c2;
    }

    private int xxungetc(int c2) {
        return this.reader.unread(c2);
    }

    private void setParseFilename(SEXP newname) {
        if (CDefines.isEnvironment(this.parseState.srcFile)) {
            Environment env2 = (Environment)this.parseState.srcFile;
            SEXP oldname = env2.findVariableUnsafe(Symbol.get("filename"));
            if (CDefines.isString(oldname) && oldname.length() > 0 && oldname.asString().equals(newname.asString())) {
                return;
            }
            this.parseState.srcFile = new Environment(AttributeMap.newBuilder().set(CDefines.R_ClassSymbol, (SEXP)CDefines.mkString("srcfile")).build());
            CDefines.REPROTECT(this.parseState.srcFile, this.parseState.srcFileProt);
            env2.setVariableUnsafe(Symbol.get("filename"), newname);
            env2.setVariableUnsafe(Symbol.get("original"), oldname);
        } else {
            this.parseState.srcFile = newname;
            CDefines.REPROTECT(this.parseState.srcFile, this.parseState.srcFileProt);
        }
        CDefines.UNPROTECT_PTR(newname);
    }

    private int consumeNumericValue(int c2) {
        int b;
        double a;
        StringBuilder buffer = new StringBuilder();
        buffer.appendCodePoint(c2);
        int seendot = c2 == 46 ? 1 : 0;
        boolean seenexp = false;
        int last = c2;
        int nd = 0;
        boolean asNumeric = false;
        while ((Character.isDigit(c2 = this.xxgetc()) || c2 == 46 || c2 == 101 || c2 == 69 || c2 == 120 || c2 == 88 || c2 == 76) && c2 != 76) {
            if (c2 == 120 || c2 == 88) {
                if (last != 48) break;
                buffer.appendCodePoint(c2);
                while (Character.isDigit(c2 = this.xxgetc()) || 97 <= c2 && c2 <= 102 || 65 <= c2 && c2 <= 70 || c2 == 46) {
                    buffer.appendCodePoint(c2);
                    ++nd;
                }
                if (nd == 0) {
                    return 259;
                }
                if (c2 != 112 && c2 != 80) break;
                buffer.appendCodePoint(c2);
                c2 = this.xxgetc();
                if (!Character.isDigit(c2) && c2 != 43 && c2 != 45) {
                    return 259;
                }
                if (c2 == 43 || c2 == 45) {
                    buffer.appendCodePoint(c2);
                    c2 = this.xxgetc();
                }
                nd = 0;
                while (Character.isDigit(c2)) {
                    buffer.appendCodePoint(c2);
                    c2 = this.xxgetc();
                    ++nd;
                }
                if (nd != 0) break;
                return 259;
            }
            if (c2 == 69 || c2 == 101) {
                if (seenexp) break;
                seenexp = true;
                seendot = seendot == 1 ? seendot : 2;
                buffer.appendCodePoint(c2);
                c2 = this.xxgetc();
                if (!Character.isDigit(c2) && c2 != 43 && c2 != 45) {
                    return 259;
                }
                if (c2 == 43 || c2 == 45) {
                    buffer.appendCodePoint(c2);
                    c2 = this.xxgetc();
                    if (!Character.isDigit(c2)) {
                        return 259;
                    }
                }
            }
            if (c2 == 46) {
                if (seendot != 0) break;
                seendot = 1;
            }
            buffer.appendCodePoint(c2);
            last = c2;
        }
        if (c2 == 76 && (a = NumericLiterals.parseDouble(buffer.toString())) != (double)(b = (int)a)) {
            if (this.parseOptions.isGenerateCode()) {
                if (seendot == 1 && !seenexp) {
                    logger.warning(String.format("integer literal %sL contains decimal; using numeric value", buffer.toString()));
                } else {
                    logger.warning(String.format("non-integer value %s qualified with L; using numeric value", buffer));
                }
            }
            asNumeric = true;
            seenexp = true;
        }
        if (c2 == 105) {
            this.yylval = this.parseOptions.isGenerateCode() ? this.mkComplex(buffer.toString()) : Null.INSTANCE;
        } else if (c2 == 76 && !asNumeric) {
            if (this.parseOptions.isGenerateCode() && seendot == 1 && !seenexp) {
                logger.warning(String.format("integer literal %sL contains unnecessary decimal point", buffer.toString()));
            }
            a = NumericLiterals.parseDouble(buffer);
            b = (int)a;
            this.yylval = this.parseOptions.isGenerateCode() ? new IntArrayVector(b) : Null.INSTANCE;
        } else {
            if (c2 != 76) {
                this.xxungetc(c2);
            }
            this.yylval = this.parseOptions.isGenerateCode() ? new DoubleArrayVector(NumericLiterals.parseDouble(buffer)) : Null.INSTANCE;
        }
        return 261;
    }

    private int skipSpace() {
        int c2;
        while ((c2 = this.xxgetc()) == 32 || c2 == 9 || c2 == 12 || c2 == 160) {
        }
        return c2;
    }

    private SEXP mkComplex(String s) {
        AbstractSEXP t2 = Null.INSTANCE;
        double f = NumericLiterals.parseDouble(s);
        if (this.parseOptions.isGenerateCode()) {
            t2 = new ComplexArrayVector(new Complex(0.0, f));
        }
        return t2;
    }

    private int consumeStringValue(int c2, boolean forSymbol) {
        int quote = c2;
        int have_warned = 0;
        CTEXT ctext = new CTEXT();
        StringBuffer stext = new StringBuffer();
        while ((c2 = this.xxgetc()) != -1 && c2 != quote) {
            ctext.push(c2);
            if (c2 == 10) {
                this.xxungetc(c2);
                c2 = 92;
            }
            if (c2 == 92) {
                int ext;
                int i;
                int val;
                c2 = this.xxgetc();
                ctext.push(c2);
                if (48 <= c2 && c2 <= 56) {
                    int octal = c2 - 48;
                    c2 = this.xxgetc();
                    if (48 <= c2 && c2 <= 56) {
                        ctext.push(c2);
                        octal = 8 * octal + c2 - 48;
                        c2 = this.xxgetc();
                        if (48 <= c2 && c2 <= 56) {
                            ctext.push(c2);
                            octal = 8 * octal + c2 - 48;
                        } else {
                            this.xxungetc(c2);
                            ctext.pop();
                        }
                    } else {
                        this.xxungetc(c2);
                        ctext.pop();
                    }
                    c2 = octal;
                } else if (c2 == 120) {
                    val = 0;
                    for (i = 0; i < 2; ++i) {
                        c2 = this.xxgetc();
                        ctext.push(c2);
                        if (c2 >= 48 && c2 <= 57) {
                            ext = c2 - 48;
                        } else if (c2 >= 65 && c2 <= 70) {
                            ext = c2 - 65 + 10;
                        } else if (c2 >= 97 && c2 <= 102) {
                            ext = c2 - 97 + 10;
                        } else {
                            this.xxungetc(c2);
                            ctext.pop();
                            if (i != 0) break;
                            if (this.parseOptions.isGenerateCode() && this.parseOptions.isWarnEscapes()) {
                                ++have_warned;
                                logger.warning("'\\x' used without hex digits");
                            }
                            val = 120;
                            break;
                        }
                        val = 16 * val + ext;
                    }
                    c2 = val;
                } else {
                    boolean delim;
                    if (c2 == 117) {
                        val = 0;
                        delim = false;
                        if (forSymbol) {
                            throw new RLexException(String.format("\\uxxxx sequences not supported inside backticks (line %d)", this.reader.getColumnNumber()));
                        }
                        c2 = this.xxgetc();
                        if (c2 == 123) {
                            delim = true;
                            ctext.push(c2);
                        } else {
                            this.xxungetc(c2);
                        }
                        for (i = 0; i < 4; ++i) {
                            c2 = this.xxgetc();
                            ctext.push(c2);
                            if (c2 >= 48 && c2 <= 57) {
                                ext = c2 - 48;
                            } else if (c2 >= 65 && c2 <= 70) {
                                ext = c2 - 65 + 10;
                            } else if (c2 >= 97 && c2 <= 102) {
                                ext = c2 - 97 + 10;
                            } else {
                                this.xxungetc(c2);
                                ctext.pop();
                                if (i != 0) break;
                                if (this.parseOptions.isGenerateCode() && this.parseOptions.isWarnEscapes()) {
                                    ++have_warned;
                                    logger.warning("\\u used without hex digits");
                                }
                                val = 117;
                                break;
                            }
                            val = 16 * val + ext;
                        }
                        if (delim) {
                            c2 = this.xxgetc();
                            if (c2 != 125) {
                                throw new RLexException(String.format("invalid \\u{xxxx} sequence (line %d)", this.reader.getLineNumber()));
                            }
                            ctext.push(c2);
                        }
                        stext.appendCodePoint(val);
                        continue;
                    }
                    if (c2 == 85) {
                        val = 0;
                        delim = false;
                        if (forSymbol) {
                            throw new RLexException(String.format("\\Uxxxxxxxx sequences not supported inside backticks (line %d)", this.reader.getLineNumber()));
                        }
                        c2 = this.xxgetc();
                        if (c2 == 123) {
                            delim = true;
                            ctext.push(c2);
                        } else {
                            this.xxungetc(c2);
                        }
                        for (i = 0; i < 8; ++i) {
                            c2 = this.xxgetc();
                            ctext.push(c2);
                            if (c2 >= 48 && c2 <= 57) {
                                ext = c2 - 48;
                            } else if (c2 >= 65 && c2 <= 70) {
                                ext = c2 - 65 + 10;
                            } else if (c2 >= 97 && c2 <= 102) {
                                ext = c2 - 97 + 10;
                            } else {
                                this.xxungetc(c2);
                                ctext.pop();
                                if (i != 0) break;
                                if (this.parseOptions.isGenerateCode() && this.parseOptions.isWarnEscapes()) {
                                    ++have_warned;
                                    logger.warning("\\U used without hex digits");
                                }
                                val = 85;
                                break;
                            }
                            val = 16 * val + ext;
                        }
                        if (delim) {
                            c2 = this.xxgetc();
                            if (c2 != 125) {
                                logger.severe(String.format("invalid \\U{xxxxxxxx} sequence (line %d)", this.reader.getLineNumber()));
                            } else {
                                ctext.push(c2);
                            }
                        }
                        ctext.push(val);
                        continue;
                    }
                    switch (c2) {
                        case 97: {
                            c2 = 7;
                            break;
                        }
                        case 98: {
                            c2 = 8;
                            break;
                        }
                        case 102: {
                            c2 = 12;
                            break;
                        }
                        case 110: {
                            c2 = 10;
                            break;
                        }
                        case 114: {
                            c2 = 13;
                            break;
                        }
                        case 116: {
                            c2 = 9;
                            break;
                        }
                        case 118: {
                            c2 = 11;
                            break;
                        }
                        case 92: {
                            c2 = 92;
                            break;
                        }
                        case 10: 
                        case 32: 
                        case 34: 
                        case 39: {
                            break;
                        }
                        default: {
                            if (!this.parseOptions.isGenerateCode() || !this.parseOptions.isWarnEscapes()) break;
                            ++have_warned;
                            logger.warning(String.format("'\\%c' is an unrecognized escape in a character string", Character.valueOf((char)c2)));
                        }
                    }
                }
            }
            stext.appendCodePoint(c2);
        }
        if (forSymbol) {
            this.yylval = Symbol.get(stext.toString());
            return 263;
        }
        this.yylval = StringVector.valueOf(stext.toString());
        if (have_warned != 0) {
            logger.warning(String.format("unrecognized escape(s) removed from \"%s\"", ctext));
        }
        return 260;
    }

    private int consumeSpecialValue(int c2) {
        StringBuffer buffer = new StringBuffer();
        buffer.appendCodePoint(c2);
        while ((c2 = this.xxgetc()) != -1 && c2 != 37) {
            if (c2 == 10) {
                this.xxungetc(c2);
                return 259;
            }
            buffer.appendCodePoint(c2);
        }
        if (c2 == 37) {
            buffer.appendCodePoint(c2);
        }
        this.yylval = Symbol.get(buffer.toString());
        return 293;
    }

    private int consumeSymbolValue(int c2) {
        StringBuffer buffer = new StringBuffer();
        do {
            buffer.appendCodePoint(c2);
        } while ((c2 = this.xxgetc()) != -1 && (Character.isLetterOrDigit(c2) || c2 == 46 || c2 == 95));
        this.xxungetc(c2);
        int keyword = this.lookupKeyword(buffer.toString());
        if (keyword != 0) {
            if (keyword == 264) {
                this.parseState.getFunctionSource().descend();
            }
            return keyword;
        }
        this.yylval = Symbol.get(buffer.toString());
        return 263;
    }

    private int lookupKeyword(String s) {
        for (int i = 0; i != this.keywords.length; ++i) {
            if (!this.keywords[i].name.equals(s)) continue;
            switch (this.keywords[i].token) {
                case 262: {
                    this.yylval = Null.INSTANCE;
                    break;
                }
                case 261: {
                    if (this.parseOptions.isGenerateCode()) {
                        switch (i) {
                            case 1: {
                                this.yylval = new LogicalArrayVector(Logical.NA);
                                break;
                            }
                            case 2: {
                                this.yylval = new LogicalArrayVector(true);
                                break;
                            }
                            case 3: {
                                this.yylval = new LogicalArrayVector(false);
                                break;
                            }
                            case 4: {
                                this.yylval = new DoubleArrayVector(Double.POSITIVE_INFINITY);
                                break;
                            }
                            case 5: {
                                this.yylval = new DoubleArrayVector(Double.NaN);
                                break;
                            }
                            case 6: {
                                this.yylval = new IntArrayVector(Integer.MIN_VALUE);
                                break;
                            }
                            case 7: {
                                this.yylval = new DoubleArrayVector(DoubleVector.NA);
                                break;
                            }
                            case 8: {
                                this.yylval = StringVector.valueOf(StringVector.NA);
                                break;
                            }
                            case 9: {
                                this.yylval = new ComplexArrayVector(new Complex(DoubleVector.NA, DoubleVector.NA));
                            }
                        }
                        break;
                    }
                    this.yylval = Null.INSTANCE;
                    break;
                }
                case 264: 
                case 269: 
                case 271: 
                case 273: 
                case 274: 
                case 275: 
                case 276: {
                    this.yylval = Symbol.get(s);
                    break;
                }
                case 270: 
                case 272: {
                    break;
                }
                case 263: {
                    this.yylval = Symbol.get(s);
                }
            }
            return this.keywords[i].token;
        }
        return 0;
    }

    public boolean isEof() {
        int c2 = this.xxgetc();
        this.xxungetc(c2);
        return c2 == -1;
    }

    public int getCharacterPos() {
        return this.reader.getCharacterIndex();
    }

    private static class CTEXT {
        private StringBuffer buffer = new StringBuffer();

        private CTEXT() {
        }

        public void push(int c2) {
            this.buffer.appendCodePoint(c2);
        }

        public void pop() {
            this.buffer.setLength(this.buffer.length() - 1);
        }

        public String toString() {
            return this.buffer.toString();
        }
    }

    private static class Keyword {
        public String name;
        public int token;

        public Keyword(String name, int token) {
            this.name = name;
            this.token = token;
        }
    }
}

