/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.util.MathUtils;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Cast;
import org.renjin.invoke.annotations.CastStyle;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.DataParallel;
import org.renjin.invoke.annotations.Deferrable;
import org.renjin.invoke.annotations.GroupGeneric;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.PreserveAttributeStyle;
import org.renjin.nmath.cospi;
import org.renjin.nmath.gamma;
import org.renjin.nmath.lgamma;
import org.renjin.nmath.polygamma;
import org.renjin.repackaged.guava.math.IntMath;
import org.renjin.sexp.ComplexArrayVector;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

@GroupGeneric(value="Math")
public class MathGroup {
    private static final int DBL_MAX_10_EXP = 308;
    private static final int MAX_DIGITS = 308;

    private MathGroup() {
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double gamma(double x) {
        return gamma.gammafn((double)x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double lgamma(double x) {
        return lgamma.lgammafn((double)x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double digamma(double x) {
        return polygamma.digamma((double)x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double trigamma(double x) {
        return polygamma.trigamma((double)x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double sign(double x) {
        return Math.signum(x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double log(double x, double base) {
        return MathUtils.log((double)base, (double)x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double log(double d) {
        return Math.log(d);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double log2(double d) {
        return MathUtils.log((double)2.0, (double)d);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double log10(double d) {
        return Math.log10(d);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double abs(@Cast(value=CastStyle.EXPLICIT) double x) {
        return Math.abs(x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL)
    public static int abs(@Cast(value=CastStyle.EXPLICIT) int x) {
        return Math.abs(x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double abs(Complex x) {
        return x.abs();
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double sqrt(double x) {
        return Math.sqrt(x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double sin(double x) {
        return Math.sin(x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double sinh(double x) {
        return Math.sinh(x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double sinpi(double x) {
        return cospi.sinpi((double)x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double asin(double val) {
        return Math.asin(val);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double asinh(double val) {
        if (Double.isInfinite(val)) {
            return val;
        }
        return Math.log(val + Math.sqrt(val * val + 1.0));
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double cos(double val) {
        return Math.cos(val);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double cosh(double val) {
        return Math.cosh(val);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double cospi(double x) {
        return cospi.cospi((double)x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double acos(double val) {
        return Math.acos(val);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double acosh(double val) {
        return Math.log(val + Math.sqrt(val + 1.0) * Math.sqrt(val - 1.0));
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double atanh(double val) {
        return 0.5 * Math.log((1.0 + val) / (1.0 - val));
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double tan(double x) {
        return Math.tan(x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double tanh(double x) {
        return Math.tanh(x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double tanpi(double x) {
        return cospi.tanpi((double)x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double atan(double x) {
        return Math.atan(x);
    }

    @Deferrable
    @Internal
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double atan2(double y, double x) {
        return Math.atan2(y, x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double signif(double x) {
        return MathGroup.signif(x, 6);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double signif(double x, int digits) {
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            return x;
        }
        if (digits <= 0) {
            digits = 1;
        }
        return new BigDecimal(x).round(new MathContext(digits, RoundingMode.HALF_UP)).doubleValue();
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL)
    public static Complex exp(Complex x) {
        return x.exp();
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double exp(double x) {
        return Math.exp(x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double expm1(double x) {
        return Math.expm1(x);
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double log1p(double x) {
        return Math.log1p(x);
    }

    @Builtin
    @Deferrable
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double floor(double x) {
        return Math.floor(x);
    }

    @Builtin
    @Deferrable
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double ceiling(double x) {
        return Math.ceil(x);
    }

    @Builtin
    @Deferrable
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double round(double x) {
        return Math.rint(x);
    }

    @Builtin
    @Deferrable
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double round(double x, int digits) {
        double sign2;
        if (Double.isNaN(x) || Double.isNaN(digits)) {
            return x + (double)digits;
        }
        if (!DoubleVector.isFinite(x)) {
            return x;
        }
        if ((double)digits == Double.POSITIVE_INFINITY) {
            return x;
        }
        if ((double)digits == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (digits > 308) {
            digits = 308;
        }
        int dig = (int)Math.floor((double)digits + 0.5);
        if (x < 0.0) {
            sign2 = -1.0;
            x = -x;
        } else {
            sign2 = 1.0;
        }
        if (dig == 0) {
            return sign2 * Math.rint(x);
        }
        if (dig > 0) {
            return sign2 * new BigDecimal(x).setScale(digits, RoundingMode.HALF_EVEN).doubleValue();
        }
        double pow10 = Math.pow(10.0, -dig);
        return sign2 * Math.rint(x / pow10) * pow10;
    }

    @Builtin
    @Deferrable
    @DataParallel(value=PreserveAttributeStyle.ALL)
    public static Complex round(Complex x, int digits) {
        return ComplexVector.complex(MathGroup.round(x.getReal(), digits), MathGroup.round(x.getImaginary(), digits));
    }

    @Deferrable
    @Builtin
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double trunc(double x) {
        if (x < 0.0) {
            return Math.ceil(x);
        }
        return Math.floor(x);
    }

    @Builtin
    public static DoubleVector cumsum(DoubleVector source) {
        return MathGroup.cumulativeRealSum(source);
    }

    @Builtin
    public static DoubleVector cumsum(RawVector source) {
        return MathGroup.cumulativeRealSum(source);
    }

    @Builtin
    public static IntVector cumsum(@Current Context context, IntVector source) {
        return MathGroup.cumulativeIntegerSum(source);
    }

    @Builtin
    public static ComplexVector cumsum(ComplexVector source) {
        ComplexArrayVector.Builder result = new ComplexArrayVector.Builder(source.length());
        result.setAttribute(Symbols.NAMES, (SEXP)source.getNames());
        Complex sum2 = ComplexVector.complex(0.0);
        for (int i = 0; i < source.length() && !source.isElementNA(i); ++i) {
            sum2 = sum2.add(source.getElementAsComplex(i));
            result.set(i, sum2);
        }
        return result.build();
    }

    @Builtin
    public static IntVector cumsum(@Current Context context, LogicalVector source) {
        return MathGroup.cumulativeIntegerSum(source);
    }

    @Builtin
    public static DoubleVector cumsum(StringVector source) {
        return MathGroup.cumulativeRealSum(source);
    }

    @Builtin
    public static DoubleVector cumsum(Null x) {
        return DoubleVector.EMPTY;
    }

    private static DoubleVector cumulativeRealSum(Vector source) {
        DoubleArrayVector.Builder result = new DoubleArrayVector.Builder(source.length());
        result.setAttribute(Symbols.NAMES, (SEXP)source.getNames());
        double sum2 = 0.0;
        for (int i = 0; i < source.length() && !Double.isNaN(sum2 += source.getElementAsDouble(i)); ++i) {
            result.set(i, sum2);
        }
        return result.build();
    }

    private static IntVector cumulativeIntegerSum(Vector source) {
        int x;
        IntArrayVector.Builder result = new IntArrayVector.Builder(source.length());
        result.setAttribute(Symbols.NAMES, (SEXP)source.getNames());
        int sum2 = 0;
        for (int i = 0; i < source.length() && (x = source.getElementAsInt(i)) != Integer.MIN_VALUE; ++i) {
            try {
                sum2 = IntMath.checkedAdd((int)sum2, (int)x);
            }
            catch (ArithmeticException e) {
                break;
            }
            result.set(i, sum2);
        }
        return result.build();
    }

    @Builtin
    public static DoubleVector cumprod(Null source) {
        return MathGroup.cumulativeRealProduct(source);
    }

    @Builtin
    public static DoubleVector cumprod(StringVector source) {
        return MathGroup.cumulativeRealProduct(source);
    }

    @Builtin
    public static DoubleVector cumprod(IntVector source) {
        return MathGroup.cumulativeRealProduct(source);
    }

    @Builtin
    public static DoubleVector cumprod(LogicalVector source) {
        return MathGroup.cumulativeRealProduct(source);
    }

    @Builtin
    public static DoubleVector cumprod(DoubleVector source) {
        return MathGroup.cumulativeRealProduct(source);
    }

    private static DoubleVector cumulativeRealProduct(Vector source) {
        DoubleArrayVector.Builder result = new DoubleArrayVector.Builder();
        result.setAttribute(Symbols.NAMES, (SEXP)source.getNames());
        if (source.length() > 0) {
            double prod2 = source.getElementAsDouble(0);
            result.add(prod2);
            for (int i = 1; i < source.length(); ++i) {
                result.add(prod2 *= source.getElementAsDouble(i));
            }
        }
        return result.build();
    }

    @Builtin
    public static ComplexVector cumprod(ComplexVector source) {
        ComplexArrayVector.Builder result = new ComplexArrayVector.Builder();
        result.setAttribute(Symbols.NAMES, (SEXP)source.getNames());
        if (source.length() > 0) {
            Complex prod2 = source.getElementAsComplex(0);
            result.add(prod2);
            for (int i = 1; i < source.length(); ++i) {
                if (ComplexVector.isNA(prod2)) {
                    result.add(ComplexVector.NA);
                    continue;
                }
                prod2 = prod2.multiply(source.getElementAsComplex(i));
                result.add(prod2);
            }
        }
        return result.build();
    }

    @Builtin
    public static DoubleVector cummax(DoubleVector source) {
        return MathGroup.cumulativeDoubleExtrema(source, false);
    }

    @Builtin
    public static IntVector cummax(LogicalVector source) {
        return MathGroup.cumulativeIntegerExtrema(source, false);
    }

    @Builtin
    public static DoubleVector cummax(StringVector source) {
        return MathGroup.cumulativeDoubleExtrema(source, false);
    }

    @Builtin
    public static IntVector cummax(IntVector source) {
        return MathGroup.cumulativeIntegerExtrema(source, false);
    }

    @Builtin
    public static DoubleVector cummin(DoubleVector source) {
        return MathGroup.cumulativeDoubleExtrema(source, true);
    }

    @Builtin
    public static IntVector cummin(LogicalVector source) {
        return MathGroup.cumulativeIntegerExtrema(source, true);
    }

    @Builtin
    public static DoubleVector cummin(StringVector source) {
        return MathGroup.cumulativeDoubleExtrema(source, true);
    }

    @Builtin
    public static IntVector cummin(IntVector source) {
        return MathGroup.cumulativeIntegerExtrema(source, true);
    }

    @Builtin
    public static ComplexVector cummin(ComplexVector source) {
        return MathGroup.cumulativeExtrema("cummin", source);
    }

    @Builtin
    public static ComplexVector cummax(ComplexVector source) {
        return MathGroup.cumulativeExtrema("cummax", source);
    }

    @Builtin
    public static DoubleVector cummin(Null x) {
        return DoubleVector.EMPTY;
    }

    @Builtin
    public static DoubleVector cummax(Null x) {
        return DoubleVector.EMPTY;
    }

    private static ComplexVector cumulativeExtrema(String functionName, ComplexVector source) {
        if (source.length() == 0) {
            if (source.getNames() == Null.INSTANCE) {
                return ComplexVector.EMPTY;
            }
            return ComplexVector.NAMED_EMPTY;
        }
        throw new EvalException(String.format("'%s' not defined for complex numbers", functionName), new Object[0]);
    }

    private static DoubleVector cumulativeDoubleExtrema(Vector source, boolean min2) {
        DoubleArrayVector.Builder result = new DoubleArrayVector.Builder(0, source.length());
        result.setAttribute(Symbols.NAMES, (SEXP)source.getNames());
        if (source.length() > 0) {
            double extrema = source.getElementAsDouble(0);
            result.add(extrema);
            for (int i = 1; i < source.length(); ++i) {
                double value = source.getElementAsDouble(i);
                if (Double.isNaN(value)) {
                    extrema = value;
                } else if (!Double.isNaN(extrema)) {
                    if (min2) {
                        if (value < extrema) {
                            extrema = value;
                        }
                    } else if (value > extrema) {
                        extrema = value;
                    }
                }
                result.add(extrema);
            }
        }
        return result.build();
    }

    private static IntVector cumulativeIntegerExtrema(Vector source, boolean min2) {
        IntArrayVector.Builder result = new IntArrayVector.Builder(0, source.length());
        result.setAttribute(Symbols.NAMES, (SEXP)source.getNames());
        if (source.length() > 0) {
            int extrema = source.getElementAsInt(0);
            result.add(extrema);
            for (int i = 1; i < source.length(); ++i) {
                int value = source.getElementAsInt(i);
                if (IntVector.isNA(value)) {
                    extrema = value;
                } else if (!IntVector.isNA(extrema)) {
                    if (min2) {
                        if (value < extrema) {
                            extrema = value;
                        }
                    } else if (value > extrema) {
                        extrema = value;
                    }
                }
                result.add(extrema);
            }
        }
        return result.build();
    }
}

