/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.codegen.ArgumentException;
import org.renjin.invoke.codegen.ArgumentIterator;
import org.renjin.invoke.codegen.WrapperRuntime;
import org.renjin.sexp.BuiltinFunction;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;
import org.renjin.stats.internals.Distributions;

public class R$primitive$dt
extends BuiltinFunction {
    public R$primitive$dt() {
        super("dt");
    }

    @Override
    public SEXP apply(Context context, Environment environment2, FunctionCall call2, PairList args2) {
        try {
            ArgumentIterator argIt = new ArgumentIterator(context, environment2, args2);
            SEXP s0 = argIt.evalNext();
            SEXP s1 = argIt.evalNext();
            SEXP s2 = argIt.evalNext();
            if (!argIt.hasNext()) {
                return R$primitive$dt.doApply(context, environment2, s0, s1, s2);
            }
            throw new EvalException("dt: too many arguments, expected at most 3.", new Object[0]);
        }
        catch (ArgumentException e) {
            throw new EvalException(context, "Invalid argument: %s. Expected:\n\tdt(double, double, logical)", e.getMessage());
        }
        catch (EvalException e) {
            e.initContext(context);
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvalException(e);
        }
    }

    public static SEXP doApply(Context context, Environment environment2, FunctionCall call2, String[] argNames, SEXP[] args2) {
        try {
            if (args2.length == 3) {
                return R$primitive$dt.doApply(context, environment2, args2[0], args2[1], args2[2]);
            }
        }
        catch (EvalException e) {
            e.initContext(context);
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvalException(e);
        }
        throw new EvalException("dt: max arity is 3", new Object[0]);
    }

    @Override
    public SEXP apply(Context context, Environment environment2, FunctionCall call2, String[] argNames, SEXP[] args2) {
        return R$primitive$dt.doApply(context, environment2, call2, argNames, args2);
    }

    public static SEXP doApply(Context context, Environment environment2, SEXP arg0, SEXP arg1, SEXP arg2) throws Exception {
        if (arg0 instanceof Vector && DoubleVector.VECTOR_TYPE.isWiderThanOrEqualTo((Vector)arg0) && arg1 instanceof Vector && DoubleVector.VECTOR_TYPE.isWiderThanOrEqualTo((Vector)arg1) && arg2 instanceof Vector) {
            int cycles;
            Vector vector0 = WrapperRuntime.convertToVector(arg0);
            int length0 = vector0.length();
            int currentElementIndex0 = 0;
            Vector vector1 = WrapperRuntime.convertToVector(arg1);
            int length1 = vector1.length();
            int currentElementIndex1 = 0;
            Vector vector2 = WrapperRuntime.convertToVector(arg2);
            int length2 = vector2.length();
            int currentElementIndex2 = 0;
            if (length0 == 0 || length1 == 0 || length2 == 0) {
                cycles = 0;
            } else {
                cycles = 0;
                if (length0 > cycles) {
                    cycles = length0;
                }
                if (length1 > cycles) {
                    cycles = length1;
                }
                if (length2 > cycles) {
                    cycles = length2;
                }
            }
            DoubleArrayVector.Builder builder = new DoubleArrayVector.Builder(cycles);
            for (int i = 0; i != cycles; ++i) {
                double s0 = vector0.getElementAsDouble(currentElementIndex0);
                double s1 = vector1.getElementAsDouble(currentElementIndex1);
                int s2 = vector2.getElementAsRawLogical(currentElementIndex2);
                if (Double.isNaN(s0) || Double.isNaN(s1) || LogicalVector.isNA(s2)) {
                    builder.setNA(i);
                } else {
                    builder.set(i, Distributions.dt(s0, s1, s2 != 0));
                }
                if (++currentElementIndex0 == length0) {
                    currentElementIndex0 = 0;
                }
                if (++currentElementIndex1 == length1) {
                    currentElementIndex1 = 0;
                }
                if (++currentElementIndex2 != length2) continue;
                currentElementIndex2 = 0;
            }
            if (length0 == cycles) {
                builder.combineStructuralAttributesFrom(vector0);
            }
            if (length1 == cycles) {
                builder.combineStructuralAttributesFrom(vector1);
            }
            if (length2 == cycles) {
                builder.combineStructuralAttributesFrom(vector2);
            }
            return builder.build();
        }
        throw new EvalException(String.format("Invalid argument:\n\tdt(%s, %s, %s)\n\tExpected:\n\tdt(double, double, logical)", arg0.getTypeName(), arg1.getTypeName(), arg2.getTypeName()), new Object[0]);
    }
}

