/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Internal;
import org.renjin.repackaged.guava.base.Charsets;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public final class Raw {
    @Internal
    public static RawVector rawToBits(RawVector vector2) {
        RawVector.Builder bits = new RawVector.Builder();
        for (int i = 0; i != vector2.length(); ++i) {
            int intValue = vector2.getElementAsInt(i);
            for (int bit = 0; bit != 8; ++bit) {
                int mask = 1 << bit;
                if ((intValue & mask) != 0) {
                    bits.add(1);
                    continue;
                }
                bits.add(0);
            }
        }
        return bits.build();
    }

    @Internal
    public static StringVector rawToChar(RawVector vector2, boolean multiple) {
        byte[] bytes = vector2.toByteArray();
        if (multiple) {
            StringVector.Builder result = new StringVector.Builder(0, vector2.length());
            for (int i = 0; i != vector2.length(); ++i) {
                result.add(StringVector.valueOf(new String(bytes, i, 1)));
            }
            return result.build();
        }
        return StringVector.valueOf(new String(bytes));
    }

    @Internal
    public static RawVector charToRaw(StringVector sv) {
        if (sv.length() != 1) {
            throw new EvalException("argument should be a character vector of length 1", new Object[0]);
        }
        return new RawVector(sv.getElementAsString(0).getBytes(Charsets.UTF_8));
    }

    @Internal
    public static RawVector rawShift(RawVector rv, int n) {
        if (n > RawVector.NUM_BITS || n < -1 * RawVector.NUM_BITS) {
            throw new EvalException("argument 'shift' must be a small integer", new Object[0]);
        }
        RawVector.Builder b = new RawVector.Builder();
        for (int i = 0; i < rv.length(); ++i) {
            int r = n >= 0 ? rv.getElementAsByte(i) << Math.abs(n) : rv.getElementAsByte(i) >> Math.abs(n);
            b.add(r);
        }
        return b.build();
    }

    @Internal
    public static RawVector intToBits(Vector vector2) {
        RawVector.Builder bits = new RawVector.Builder();
        for (int i = 0; i != vector2.length(); ++i) {
            int intValue = vector2.getElementAsInt(i);
            for (int bit = 0; bit != 32; ++bit) {
                int mask = 1 << bit;
                if ((intValue & mask) != 0) {
                    bits.add(1);
                    continue;
                }
                bits.add(0);
            }
        }
        return bits.build();
    }
}

