/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.io.IOException;
import org.apache.commons.math.complex.Complex;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Deferrable;
import org.renjin.invoke.annotations.GroupGeneric;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.NamedFlag;
import org.renjin.parser.NumericLiterals;
import org.renjin.primitives.summary.DeferredMean;
import org.renjin.primitives.summary.DeferredSum;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ComplexArrayVector;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class Summary {
    private Summary() {
    }

    @Builtin
    @GroupGeneric
    public static SEXP min(@ArgumentList ListVector arguments, @NamedFlag(value="na.rm") boolean removeNA) {
        return new RangeCalculator().setRemoveNA(removeNA).addList(arguments).getMinimum();
    }

    @Builtin
    @GroupGeneric
    public static SEXP max(@ArgumentList ListVector arguments, @NamedFlag(value="na.rm") boolean removeNA) {
        return new RangeCalculator().setRemoveNA(removeNA).addList(arguments).getMaximum();
    }

    @Builtin
    @GroupGeneric
    public static Vector range(@ArgumentList ListVector arguments, @NamedFlag(value="na.rm") boolean removeNA) {
        return new RangeCalculator().setRemoveNA(removeNA).setRecursive(true).addList(arguments).getRange();
    }

    @Builtin
    @GroupGeneric
    public static AtomicVector prod(@ArgumentList ListVector arguments, @NamedFlag(value="na.rm") boolean removeNA) {
        double realProduct = Summary.realProduct(arguments, removeNA);
        Complex complexProduct = Summary.complexProduct(arguments, removeNA);
        if (complexProduct == null) {
            return DoubleVector.valueOf(realProduct);
        }
        if (complexProduct.equals((Object)ComplexVector.NA)) {
            return ComplexVector.valueOf(complexProduct);
        }
        return ComplexVector.valueOf(complexProduct.multiply(realProduct));
    }

    private static double realProduct(ListVector arguments, boolean removeNA) {
        double product = 1.0;
        for (SEXP argument : arguments) {
            if (!(argument instanceof AtomicVector)) {
                throw new EvalException("invalid 'type' (%s) of argument", argument.getTypeName());
            }
            if (argument instanceof StringVector) {
                throw new EvalException("invalid 'type' (character) of argument", new Object[0]);
            }
            if (argument instanceof ComplexVector) continue;
            AtomicVector vector2 = (AtomicVector)argument;
            for (int i = 0; i != vector2.length(); ++i) {
                if (vector2.isElementNA(i)) {
                    if (removeNA) continue;
                    return DoubleVector.NA;
                }
                product *= vector2.getElementAsDouble(i);
            }
        }
        return product;
    }

    private static Complex complexProduct(ListVector arguments, boolean removeNA) {
        Complex product = null;
        for (SEXP argument : arguments) {
            if (!(argument instanceof ComplexVector)) continue;
            if (product == null) {
                product = ComplexVector.complex(1.0, 0.0);
            }
            ComplexVector vector2 = (ComplexVector)argument;
            for (int i = 0; i != vector2.length(); ++i) {
                if (vector2.isElementNA(i)) {
                    if (removeNA) continue;
                    return ComplexVector.NA;
                }
                product = product.multiply(vector2.getElementAsComplex(i));
            }
        }
        return product;
    }

    @Builtin
    @GroupGeneric
    public static SEXP sum(@Current Context context, @ArgumentList ListVector arguments, @NamedFlag(value="na.rm") boolean removeNA) throws IOException {
        DoubleVector argument;
        double realSum = 0.0;
        boolean haveDouble = false;
        double imaginarySum = 0.0;
        boolean haveComplex = false;
        if (arguments.length() == 1 && arguments.get(0) instanceof DoubleVector && !removeNA && ((argument = (DoubleVector)arguments.get(0)).isDeferred() || argument.length() > 300)) {
            return new DeferredSum((Vector)arguments.get(0), AttributeMap.EMPTY);
        }
        for (SEXP argument2 : arguments) {
            int i;
            AtomicVector vector2;
            if (argument2 instanceof IntVector || argument2 instanceof LogicalVector) {
                vector2 = (AtomicVector)argument2;
                for (i = 0; i != argument2.length(); ++i) {
                    if (vector2.isElementNA(i)) {
                        if (removeNA) continue;
                        return haveDouble ? new DoubleArrayVector(DoubleVector.NA) : new IntArrayVector(Integer.MIN_VALUE);
                    }
                    int element = vector2.getElementAsInt(i);
                    realSum += (double)element;
                }
                continue;
            }
            if (argument2 instanceof DoubleVector) {
                vector2 = (DoubleVector)argument2;
                haveDouble = true;
                for (i = 0; i != ((DoubleVector)vector2).length(); ++i) {
                    if (((DoubleVector)vector2).isElementNA(i)) {
                        if (removeNA) continue;
                        return new DoubleArrayVector(DoubleVector.NA);
                    }
                    realSum += ((DoubleVector)vector2).getElementAsDouble(i);
                }
                continue;
            }
            if (argument2 instanceof ComplexVector) {
                vector2 = (ComplexVector)argument2;
                haveComplex = true;
                for (i = 0; i != ((ComplexVector)vector2).length(); ++i) {
                    if (((ComplexVector)vector2).isElementNA(i)) {
                        if (removeNA) continue;
                        return new ComplexArrayVector(ComplexVector.NA);
                    }
                    Complex z = ((ComplexVector)vector2).getElementAsComplex(i);
                    realSum += z.getReal();
                    imaginarySum += z.getImaginary();
                }
                continue;
            }
            if (argument2 == Null.INSTANCE) continue;
            throw new EvalException("invalid 'type' (" + argument2.getTypeName() + ") of argument", new Object[0]);
        }
        if (haveComplex) {
            return new ComplexArrayVector(ComplexVector.complex(realSum, imaginarySum));
        }
        if (haveDouble) {
            return new DoubleArrayVector(realSum);
        }
        if (realSum < -2.147483648E9 || realSum > 2.147483647E9) {
            context.warn("Integer overflow - use sum(as.numeric(.))");
            return new IntArrayVector(Integer.MIN_VALUE);
        }
        return new IntArrayVector((int)realSum);
    }

    @Builtin
    @GroupGeneric
    public static Logical any(@ArgumentList ListVector arguments, @NamedFlag(value="na.rm") boolean removeNA) {
        for (SEXP argument : arguments) {
            Vector vector2 = (Vector)argument;
            for (int i = 0; i != vector2.length(); ++i) {
                int value = vector2.getElementAsRawLogical(i);
                if (value == Integer.MIN_VALUE) {
                    if (removeNA) continue;
                    return Logical.NA;
                }
                if (value == 0) continue;
                return Logical.TRUE;
            }
        }
        return Logical.FALSE;
    }

    @Builtin
    @GroupGeneric
    public static Logical all(@ArgumentList ListVector arguments, @NamedFlag(value="na.rm") boolean removeNA) {
        for (SEXP argument : arguments) {
            Vector vector2 = (Vector)argument;
            for (int i = 0; i != vector2.length(); ++i) {
                int value = vector2.getElementAsRawLogical(i);
                if (value == Integer.MIN_VALUE) {
                    if (removeNA) continue;
                    return Logical.NA;
                }
                if (value != 0) continue;
                return Logical.FALSE;
            }
        }
        return Logical.TRUE;
    }

    @Deferrable
    @Internal
    public static DoubleVector mean(Vector x) {
        if (x.isDeferred() || x.length() > 100000) {
            return new DeferredMean(x, AttributeMap.EMPTY);
        }
        double mean2 = 0.0;
        for (int i = 0; i < x.length(); ++i) {
            mean2 += x.getElementAsDouble(i);
        }
        return new DoubleArrayVector(mean2 / (double)x.length());
    }

    public double[] compute(Vector[] x) {
        double[] x_array = ((DoubleArrayVector)x[0]).toDoubleArrayUnsafe();
        double sum2 = 0.0;
        for (int i = 0; i != x_array.length; ++i) {
            sum2 += x_array[i];
        }
        return new double[]{sum2 / (double)x_array.length};
    }

    @Internal
    public static Vector pmin(boolean naRm, @ArgumentList ListVector vectors) {
        ParallelProcessor processor = new ParallelProcessor(naRm, vectors){

            @Override
            boolean predicate(Number x, Number y) {
                return ((Comparable)((Object)x)).compareTo(y) > 0;
            }
        };
        return processor.compute();
    }

    @Internal
    public static Vector pmax(boolean naRm, @ArgumentList ListVector vectors) {
        ParallelProcessor processor = new ParallelProcessor(naRm, vectors){

            @Override
            boolean predicate(Number x, Number y) {
                return ((Comparable)((Object)x)).compareTo(y) < 0;
            }
        };
        return processor.compute();
    }

    private static abstract class ParallelProcessor {
        private ListVector arguments;
        private int resultLength;
        private boolean realResult;
        private boolean naRm;

        public ParallelProcessor(boolean naRm, ListVector arguments) {
            this.arguments = arguments;
            this.naRm = naRm;
            if (arguments.length() == 0) {
                throw new EvalException("no arguments", new Object[0]);
            }
            this.resultLength = arguments.maxElementLength();
        }

        private void validateArguments() {
            for (SEXP argument : this.arguments) {
                if (argument.length() == 0) {
                    throw new EvalException("cannot mix 0-length vectors with others", new Object[0]);
                }
                if (argument instanceof DoubleVector) {
                    this.realResult = true;
                    continue;
                }
                if (argument instanceof LogicalVector || argument instanceof IntVector) continue;
                throw new EvalException("cannot handle argument of type '%s'", argument.getTypeName());
            }
        }

        public Vector compute() {
            if (this.resultLength == 0) {
                return Null.INSTANCE;
            }
            this.validateArguments();
            Vector.Builder builder = this.createBuilder();
            for (int i = 0; i != this.resultLength; ++i) {
                Number result = this.computeResult(i);
                if (result == null) {
                    builder.addNA();
                    continue;
                }
                builder.add(result);
            }
            return builder.build();
        }

        private Number computeResult(int resultIndex) {
            Number result = null;
            for (int argIndex = 0; argIndex < this.arguments.length(); ++argIndex) {
                Number value = this.getValue(argIndex, resultIndex);
                if (value == null && !this.naRm) {
                    return null;
                }
                if (result == null && value != null) {
                    result = value;
                    continue;
                }
                if (result == null || value == null || !this.predicate(result, value)) continue;
                result = value;
            }
            return result;
        }

        private Vector.Builder createBuilder() {
            if (this.realResult) {
                return new DoubleArrayVector.Builder();
            }
            return new IntArrayVector.Builder();
        }

        private Vector getVector(int index) {
            return (Vector)this.arguments.getElementAsSEXP(index);
        }

        private Number getValue(int argument, int index) {
            int vectorIndex;
            Vector vector2 = this.getVector(argument);
            if (vector2.isElementNA(vectorIndex = index % vector2.length())) {
                return null;
            }
            if (this.realResult) {
                return vector2.getElementAsDouble(vectorIndex);
            }
            return vector2.getElementAsInt(vectorIndex);
        }

        abstract boolean predicate(Number var1, Number var2);
    }

    private static class RangeCalculator {
        private boolean removeNA;
        private boolean recursive;
        private Vector.Type resultType = IntVector.VECTOR_TYPE;
        private double minDoubleValue = Double.POSITIVE_INFINITY;
        private double maxDoubleValue = Double.NEGATIVE_INFINITY;
        private int minIntValue = Integer.MAX_VALUE;
        private int maxIntValue = Integer.MIN_VALUE;
        private boolean hasValues;
        private String minStringValue;
        private String maxStringValue;
        private boolean naEncountered = false;
        private boolean nanEncountered = false;

        private RangeCalculator() {
        }

        public RangeCalculator setRemoveNA(boolean removeNA) {
            this.removeNA = removeNA;
            return this;
        }

        public RangeCalculator setRecursive(boolean recursive2) {
            this.recursive = recursive2;
            return this;
        }

        public RangeCalculator addList(ListVector list2) {
            for (SEXP argument : list2) {
                if (argument instanceof AtomicVector) {
                    this.addVector(argument);
                    continue;
                }
                if (this.recursive && argument instanceof ListVector) {
                    this.addList((ListVector)argument);
                    continue;
                }
                throw new EvalException("invalid 'type' (%s) of argument", argument.getTypeName());
            }
            return this;
        }

        private void addVector(SEXP argument) {
            AtomicVector vector2 = (AtomicVector)EvalException.checkedCast(argument);
            if (vector2 instanceof ComplexVector) {
                throw new EvalException("invalid 'type' (complex) of argument", new Object[0]);
            }
            if (vector2 instanceof StringVector) {
                this.addStringVector((StringVector)vector2);
            } else if (vector2 instanceof DoubleVector) {
                this.addDoubleVector((DoubleVector)vector2);
            } else {
                this.addIntVector(vector2);
            }
        }

        private void addIntVector(AtomicVector vector2) {
            if (this.naEncountered) {
                return;
            }
            int minValue = Integer.MAX_VALUE;
            int maxValue = Integer.MIN_VALUE;
            boolean hasValues = false;
            for (int i = 0; i < vector2.length(); ++i) {
                int value = vector2.getElementAsInt(i);
                if (IntVector.isNA(value)) {
                    if (this.removeNA) continue;
                    this.naEncountered = true;
                    return;
                }
                hasValues = true;
                minValue = Math.min(minValue, value);
                maxValue = Math.max(maxValue, value);
            }
            if (hasValues) {
                if (this.resultType == StringVector.VECTOR_TYPE) {
                    this.addStringRange(Integer.toString(minValue), Integer.toString(maxValue));
                } else {
                    this.hasValues = true;
                    this.minIntValue = Math.min(this.minIntValue, minValue);
                    this.maxIntValue = Math.max(this.maxIntValue, maxValue);
                    this.minDoubleValue = Math.min(this.minDoubleValue, (double)minValue);
                    this.maxDoubleValue = Math.max(this.maxDoubleValue, (double)maxValue);
                }
            }
        }

        private void addDoubleVector(DoubleVector vector2) {
            if (this.resultType == IntVector.VECTOR_TYPE) {
                this.resultType = DoubleVector.VECTOR_TYPE;
            }
            if (this.naEncountered) {
                return;
            }
            double minValue = Double.POSITIVE_INFINITY;
            double maxValue = Double.NEGATIVE_INFINITY;
            boolean hasValues = false;
            int length2 = vector2.length();
            for (int i = 0; i < length2; ++i) {
                double value = vector2.getElementAsDouble(i);
                if (Double.isNaN(value)) {
                    if (this.removeNA) continue;
                    if (DoubleVector.isNA(value)) {
                        this.naEncountered = true;
                        return;
                    }
                    this.nanEncountered = true;
                    break;
                }
                hasValues = true;
                if (value > maxValue) {
                    maxValue = value;
                }
                if (!(value < minValue)) continue;
                minValue = value;
            }
            if (this.nanEncountered) {
                if (this.resultType == StringVector.VECTOR_TYPE) {
                    this.addStringRange("NaN", "NaN");
                } else {
                    this.minDoubleValue = Double.NaN;
                    this.maxDoubleValue = Double.NaN;
                }
            } else if (hasValues) {
                if (this.resultType == StringVector.VECTOR_TYPE) {
                    this.addStringRange(NumericLiterals.format(minValue, "NA"), NumericLiterals.format(maxValue, "NA"));
                } else {
                    this.minDoubleValue = Math.min(this.minDoubleValue, minValue);
                    this.maxDoubleValue = Math.max(this.maxDoubleValue, maxValue);
                    this.hasValues = true;
                }
            }
        }

        private void addStringVector(StringVector vector2) {
            if (!this.naEncountered && this.hasValues) {
                if (this.resultType == IntVector.VECTOR_TYPE) {
                    this.minStringValue = Integer.toString(this.minIntValue);
                    this.maxStringValue = Integer.toString(this.maxIntValue);
                } else if (this.resultType == DoubleVector.VECTOR_TYPE) {
                    this.minStringValue = NumericLiterals.toString(this.minDoubleValue);
                    this.maxStringValue = NumericLiterals.toString(this.maxDoubleValue);
                }
            }
            this.resultType = StringVector.VECTOR_TYPE;
            if (this.naEncountered) {
                return;
            }
            String minValue = null;
            String maxValue = null;
            boolean hasValues = false;
            int length2 = vector2.length();
            for (int i = 0; i < length2; ++i) {
                String value = vector2.getElementAsString(i);
                if (value == null) {
                    if (this.removeNA) continue;
                    this.naEncountered = true;
                    return;
                }
                if (hasValues) {
                    if (value.compareTo(minValue = this.min(minValue, value)) < 0) {
                        minValue = value;
                    }
                    if (value.compareTo(maxValue) <= 0) continue;
                    maxValue = value;
                    continue;
                }
                minValue = value;
                maxValue = value;
                hasValues = true;
            }
            if (hasValues) {
                this.addStringRange(minValue, maxValue);
            }
        }

        private String min(String x, String y) {
            if (x.compareTo(y) < 0) {
                return x;
            }
            return y;
        }

        private String max(String x, String y) {
            if (x.compareTo(y) > 0) {
                return x;
            }
            return y;
        }

        private void addStringRange(String minValue, String maxValue) {
            if (this.hasValues) {
                this.minStringValue = this.min(this.minStringValue, minValue);
                this.maxStringValue = this.max(this.maxStringValue, maxValue);
            } else {
                this.minStringValue = minValue;
                this.maxStringValue = maxValue;
                this.hasValues = true;
            }
        }

        public Vector getRange() {
            if (this.nanEncountered) {
                return new DoubleArrayVector(Double.NaN, Double.NaN);
            }
            if (this.naEncountered) {
                return this.resultType.newBuilder().addNA().addNA().build();
            }
            if (!this.hasValues) {
                if (this.resultType == StringVector.VECTOR_TYPE) {
                    return new StringArrayVector(StringVector.NA, StringVector.NA);
                }
                return new DoubleArrayVector(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
            }
            if (this.resultType == IntVector.VECTOR_TYPE) {
                return new IntArrayVector(this.minIntValue, this.maxIntValue);
            }
            if (this.resultType == DoubleVector.VECTOR_TYPE) {
                return new DoubleArrayVector(this.minDoubleValue, this.maxDoubleValue);
            }
            if (this.resultType == StringVector.VECTOR_TYPE) {
                return new StringArrayVector(this.minStringValue, this.maxStringValue);
            }
            throw new UnsupportedOperationException();
        }

        public Vector getMinimum() {
            return (Vector)this.getRange().getElementAsSEXP(0);
        }

        public Vector getMaximum() {
            return (Vector)this.getRange().getElementAsSEXP(1);
        }
    }
}

