/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine;

import org.renjin.eval.Context;
import org.renjin.primitives.Deparse;
import org.renjin.primitives.combine.MatrixDim;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.Promise;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

class BindArgument {
    private final SEXP uneval;
    private final Vector vector;
    private final int rows;
    private final int cols;
    private final int deparseLevel;
    Context context;
    private SEXP expression;
    private AtomicVector rowNames = Null.INSTANCE;
    private AtomicVector colNames = Null.INSTANCE;
    private final boolean matrix;
    private String argName;
    private String computedName;

    public BindArgument(String argName, Vector vector2, MatrixDim bindDim, SEXP uneval, int deparseLevel, Context context) {
        this.argName = argName;
        this.uneval = uneval;
        this.deparseLevel = deparseLevel;
        Vector dim2 = vector2.getAttributes().getDim();
        this.vector = vector2;
        SEXP sEXP = this.expression = uneval instanceof Promise ? ((Promise)uneval).getExpression() : uneval;
        if (dim2 == Null.INSTANCE || dim2.length() != 2) {
            if (bindDim == MatrixDim.ROW) {
                this.rows = 1;
                this.cols = vector2.length();
                this.colNames = vector2.getNames();
            } else {
                this.cols = 1;
                this.rows = vector2.length();
                this.rowNames = vector2.getNames();
            }
            this.matrix = false;
        } else {
            AtomicVector dimVector = (AtomicVector)dim2;
            this.rows = dimVector.getElementAsInt(0);
            this.cols = dimVector.getElementAsInt(1);
            Vector dimNames = (Vector)this.vector.getAttribute(Symbols.DIMNAMES);
            if (dimNames instanceof ListVector && dimNames.length() == 2) {
                this.rowNames = (AtomicVector)dimNames.getElementAsSEXP(0);
                this.colNames = (AtomicVector)dimNames.getElementAsSEXP(1);
            }
            this.matrix = true;
        }
        if (this.argName != null && this.argName.length() > 0) {
            this.computedName = this.argName;
        } else if (this.deparseLevel == 1 && this.expression instanceof Symbol) {
            this.computedName = this.expression.asString();
        } else if (this.deparseLevel == 2) {
            this.computedName = Deparse.deparse(context, this.expression, 0, false, 0, 0);
            if (this.computedName.length() > 10) {
                this.computedName = this.computedName.substring(0, 10) + "...";
            }
        } else {
            this.computedName = "";
        }
    }

    public Vector getClasses() {
        return (Vector)this.vector.getAttribute(Symbols.CLASS);
    }

    public String getArgName() {
        return this.argName;
    }

    public String getName() {
        return this.computedName;
    }

    public boolean hasNoName() {
        return this.computedName.isEmpty();
    }

    public Promise repromise() {
        return new Promise(this.expression, (SEXP)this.vector);
    }

    public Vector getVector() {
        return this.vector;
    }

    public SEXP getExpression() {
        return this.expression;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public AtomicVector getRowNames() {
        return this.rowNames;
    }

    public AtomicVector getColNames() {
        return this.colNames;
    }

    public boolean isMatrix() {
        return this.matrix;
    }

    public SEXP getUneval() {
        return this.uneval;
    }

    public boolean isZeroLength() {
        return this.vector.length() == 0;
    }

    public boolean isZeroLengthVector() {
        return !this.matrix && this.vector.length() == 0;
    }

    public boolean isNull() {
        return this.vector == Null.INSTANCE;
    }

    public int getDimLength(MatrixDim dim2) {
        if (dim2 == MatrixDim.ROW) {
            return this.rows;
        }
        return this.cols;
    }

    public AtomicVector getNames(MatrixDim dim2) {
        if (dim2 == MatrixDim.ROW) {
            return this.rowNames;
        }
        return this.colNames;
    }
}

