/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine.view;

import java.util.List;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class CombinedStringVector
extends StringVector
implements DeferredComputation {
    private final Vector[] vectors;
    private final int[] endIndex;
    private final int totalLength;

    public static StringVector combine(Vector[] vectors, AttributeMap attributeMap) {
        if (vectors.length == 1) {
            return (StringVector)vectors[0].setAttributes(attributeMap);
        }
        return new CombinedStringVector(vectors, attributeMap);
    }

    public static StringVector combine(List<Vector> vectors, AttributeMap attributeMap) {
        if (vectors.size() == 1) {
            return (StringVector)vectors.get(0).setAttributes(attributeMap);
        }
        return new CombinedStringVector(vectors.toArray(new Vector[vectors.size()]), attributeMap);
    }

    private CombinedStringVector(Vector[] vectors, AttributeMap attributeMap) {
        super(attributeMap);
        this.vectors = vectors;
        this.endIndex = new int[vectors.length];
        int totalLength = 0;
        for (int i = 0; i != vectors.length; ++i) {
            this.endIndex[i] = totalLength += vectors[i].length();
        }
        this.totalLength = totalLength;
    }

    @Override
    public Vector[] getOperands() {
        return this.vectors;
    }

    @Override
    public String getComputationName() {
        return "c";
    }

    @Override
    protected StringVector cloneWithNewAttributes(AttributeMap attributes2) {
        return new CombinedStringVector(this.vectors, attributes2);
    }

    @Override
    public String getElementAsString(int index) {
        if (index < this.endIndex[0]) {
            return this.vectors[0].getElementAsString(index);
        }
        if (index < this.endIndex[1]) {
            return this.vectors[1].getElementAsString(index - this.endIndex[0]);
        }
        if (index < this.endIndex[2]) {
            return this.vectors[2].getElementAsString(index - this.endIndex[1]);
        }
        if (index < this.endIndex[3]) {
            return this.vectors[3].getElementAsString(index - this.endIndex[2]);
        }
        for (int i = 4; i < this.vectors.length; ++i) {
            if (index >= this.endIndex[i]) continue;
            return this.vectors[i].getElementAsString(index - this.endIndex[i - 1]);
        }
        throw new IllegalArgumentException("index: " + index);
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    public boolean isDeferred() {
        return true;
    }

    @Override
    public int length() {
        return this.totalLength;
    }
}

