/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.connections;

import java.io.IOException;
import org.renjin.eval.EvalException;
import org.renjin.primitives.io.connections.Connection;
import org.renjin.primitives.io.connections.StdInConnection;
import org.renjin.primitives.io.connections.StdOutConnection;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.Symbols;

public class ConnectionTable {
    public static final int STDIN_HANDLE = 0;
    public static final int STDOUT_HANDLE = 1;
    public static final int STDERR_HANDLE = 2;
    private StdInConnection stdin;
    private StdOutConnection stdout;
    private StdOutConnection stderr;
    private static final int NUM_CONNECTIONS = 128;
    private Connection[] table = new Connection[128];

    public ConnectionTable() {
        this.stdin = new StdInConnection();
        this.table[0] = this.stdin;
        this.stdout = new StdOutConnection();
        this.table[1] = this.stdout;
        this.stderr = new StdOutConnection();
        this.table[2] = this.stderr;
    }

    public IntVector newConnection(Connection conn) {
        IntArrayVector.Builder sexp = new IntArrayVector.Builder(1);
        sexp.set(0, this.installConnection(conn));
        sexp.setAttribute(Symbols.CLASS, (SEXP)new StringArrayVector("connection", conn.getClassName()));
        return sexp.build();
    }

    public void close(int index) throws IOException {
        this.table[index].close();
        this.table[index] = null;
    }

    private int installConnection(Connection conn) {
        for (int i = 0; i != this.table.length; ++i) {
            if (this.table[i] != null) continue;
            this.table[i] = conn;
            return i;
        }
        throw new EvalException("maximum number of connections exceeded", new Object[0]);
    }

    public Connection getConnection(int index) {
        if (index >= this.table.length || this.table[index] == null) {
            throw new EvalException("invalid connection", new Object[0]);
        }
        return this.table[index];
    }

    public Connection getConnection(IntVector conn) {
        return this.getConnection(conn.getElementAsInt(0));
    }

    public StdInConnection getStdin() {
        return this.stdin;
    }

    public StdOutConnection getStdout() {
        return this.stdout;
    }

    public StdOutConnection getStderr() {
        return this.stderr;
    }
}

