/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.connections;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.renjin.primitives.io.connections.Connection;
import org.renjin.primitives.io.connections.OpenSpec;
import org.renjin.primitives.io.connections.PushbackBufferedReader;

public class SingleThreadedFifoConnection
implements Connection {
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private PushbackBufferedReader reader;
    private PrintWriter writer = new PrintWriter(this.out);

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getContent());
    }

    protected byte[] getContent() {
        this.writer.flush();
        byte[] content = this.out.toByteArray();
        this.out.reset();
        return content;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public PushbackBufferedReader getReader() throws IOException {
        this.reader = new PushbackBufferedReader(new InputStreamReader(new ByteArrayInputStream(this.getContent())));
        return this.reader;
    }

    @Override
    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    @Override
    public PrintWriter getOpenPrintWriter() {
        return this.writer;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void open(OpenSpec spec) throws IOException {
    }

    @Override
    public String getClassName() {
        return "fifo";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getMode() {
        return "rw";
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public Connection.Type getType() {
        return Connection.Type.TEXT;
    }
}

