/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.connections;

import java.io.IOException;
import java.io.PrintWriter;
import org.renjin.primitives.io.connections.Connection;
import org.renjin.primitives.io.connections.SplitWriter;

class Sink {
    private Connection connection;
    private boolean split;
    private boolean closeOnExit;

    public Sink(Connection connection2, boolean split2, boolean closeOnExit) {
        this.connection = connection2;
        this.split = split2;
        this.closeOnExit = closeOnExit;
    }

    public PrintWriter getPrintWriter(PrintWriter originalStream) {
        PrintWriter sinkWriter = this.connection.getOpenPrintWriter();
        if (this.split) {
            return new PrintWriter(new SplitWriter(originalStream, sinkWriter));
        }
        return sinkWriter;
    }

    void disconnect() throws IOException {
        if (this.closeOnExit) {
            this.connection.close();
        }
    }
}

