/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.serialization;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.math.complex.Complex;
import org.renjin.eval.Context;
import org.renjin.primitives.io.serialization.Flags;
import org.renjin.primitives.io.serialization.Serialization;
import org.renjin.primitives.io.serialization.SessionWriteContext;
import org.renjin.primitives.io.serialization.Version;
import org.renjin.primitives.io.serialization.WriteContext;
import org.renjin.repackaged.guava.base.Charsets;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.BuiltinFunction;
import org.renjin.sexp.CHARSEXP;
import org.renjin.sexp.Closure;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.Promise;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.S4Object;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public class RDataWriter
implements AutoCloseable {
    private WriteContext context;
    private PersistenceHook hook;
    private DataOutputStream conn;
    private StreamWriter out;
    private Serialization.SerializationType serializationType;
    private Map<SEXP, Integer> references = Maps.newIdentityHashMap();

    public RDataWriter(WriteContext context, PersistenceHook hook, OutputStream out, Serialization.SerializationType type) {
        this.context = context;
        this.hook = hook;
        this.conn = new DataOutputStream(out);
        this.serializationType = type;
        switch (this.serializationType) {
            case ASCII: {
                this.out = new AsciiWriter(this.conn);
                break;
            }
            default: {
                this.out = new XdrWriter(this.conn);
            }
        }
    }

    public RDataWriter(Context context, PersistenceHook hook, OutputStream out) throws IOException {
        this(new SessionWriteContext(context), hook, out, Serialization.SerializationType.XDR);
    }

    public RDataWriter(Context context, OutputStream out, Serialization.SerializationType st) throws IOException {
        this(new SessionWriteContext(context), null, out, st);
    }

    public RDataWriter(Context context, OutputStream out) throws IOException {
        this(context, null, out);
    }

    public RDataWriter(WriteContext writeContext, OutputStream os) {
        this(writeContext, null, os, Serialization.SerializationType.XDR);
    }

    @Deprecated
    public void writeFile(SEXP sexp) throws IOException {
        this.save(sexp);
    }

    public void save(SEXP sexp) throws IOException {
        if (this.serializationType == Serialization.SerializationType.ASCII) {
            this.conn.writeBytes("RDA2\n");
        } else {
            this.conn.writeBytes("RDX2\n");
        }
        this.serialize(sexp);
    }

    public void serialize(SEXP exp2) throws IOException {
        if (this.serializationType == Serialization.SerializationType.ASCII) {
            this.conn.writeByte(65);
        } else {
            this.conn.writeByte(88);
        }
        this.conn.writeByte(10);
        this.writeVersion();
        this.writeExp(exp2);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    private void writeVersion() throws IOException {
        this.out.writeInt(2);
        this.out.writeInt(Version.CURRENT.asPacked());
        this.out.writeInt(new Version(2, 3, 0).asPacked());
    }

    private void writeExp(SEXP exp2) throws IOException {
        if (this.tryWriteRef(exp2)) {
            return;
        }
        if (this.tryWritePersistent(exp2)) {
            return;
        }
        if (exp2 instanceof Null) {
            this.writeNull();
        } else if (exp2 instanceof LogicalVector) {
            this.writeLogical((LogicalVector)exp2);
        } else if (exp2 instanceof IntVector) {
            this.writeIntVector((IntVector)exp2);
        } else if (exp2 instanceof DoubleVector) {
            this.writeDoubleVector((DoubleVector)exp2);
        } else if (exp2 instanceof StringVector) {
            this.writeStringVector((StringVector)exp2);
        } else if (exp2 instanceof ComplexVector) {
            this.writeComplexVector((ComplexVector)exp2);
        } else if (exp2 instanceof Promise) {
            this.writePromise((Promise)exp2);
        } else if (exp2 instanceof ListVector) {
            this.writeList((ListVector)exp2);
        } else if (exp2 instanceof FunctionCall) {
            this.writeFunctionCall((FunctionCall)exp2);
        } else if (exp2 instanceof PairList.Node) {
            this.writePairList((PairList.Node)exp2);
        } else if (exp2 instanceof Symbol) {
            this.writeSymbol((Symbol)exp2);
        } else if (exp2 instanceof Closure) {
            this.writeClosure((Closure)exp2);
        } else if (exp2 instanceof RawVector) {
            this.writeRawVector((RawVector)exp2);
        } else if (exp2 instanceof Environment) {
            this.writeEnvironment((Environment)exp2);
        } else if (exp2 instanceof PrimitiveFunction) {
            this.writePrimitive((PrimitiveFunction)exp2);
        } else if (exp2 instanceof S4Object) {
            this.writeS4((S4Object)exp2);
        } else if (exp2 instanceof ExternalPtr) {
            this.writeExternalPtr((ExternalPtr)exp2);
        } else if (exp2 instanceof CHARSEXP) {
            this.writeCharExp(((CHARSEXP)exp2).getValue());
        } else {
            throw new UnsupportedOperationException("serialization of " + exp2.getClass().getName() + " not implemented: [" + exp2.toString() + "]");
        }
    }

    private boolean tryWritePersistent(SEXP exp2) throws IOException {
        if (this.hook == null) {
            return false;
        }
        if (exp2 == Null.INSTANCE || this.isSpecialEnvironment(exp2)) {
            return false;
        }
        Vector name = this.hook.apply(exp2);
        if (name == Null.INSTANCE) {
            return false;
        }
        this.out.writeInt(247);
        this.writePersistentNameVector((StringVector)name);
        this.addRef(exp2);
        return true;
    }

    private void writePersistentNameVector(StringVector name) throws IOException {
        this.out.writeInt(0);
        this.out.writeInt(name.length());
        for (int i = 0; i != name.length(); ++i) {
            this.writeCharExp(name.getElementAsString(i));
        }
    }

    private boolean isSpecialEnvironment(SEXP exp2) {
        if (!(exp2 instanceof Environment)) {
            return false;
        }
        if (exp2 == Environment.EMPTY) {
            return true;
        }
        if (this.context.isBaseEnvironment((Environment)exp2)) {
            return true;
        }
        if (this.context.isNamespaceEnvironment((Environment)exp2)) {
            return true;
        }
        return this.isPackageEnvironment(exp2);
    }

    private boolean isPackageEnvironment(SEXP exp2) {
        return false;
    }

    private void writeNull() throws IOException {
        this.out.writeInt(254);
    }

    private void writeLogical(LogicalVector vector2) throws IOException {
        this.writeFlags(10, vector2);
        this.out.writeInt(vector2.length());
        for (int i = 0; i != vector2.length(); ++i) {
            this.out.writeInt(vector2.getElementAsRawLogical(i));
        }
        this.writeAttributes(vector2);
    }

    private void writeIntVector(IntVector vector2) throws IOException {
        this.writeFlags(13, vector2);
        this.out.writeInt(vector2.length());
        if (this.serializationType == Serialization.SerializationType.ASCII) {
            for (int i = 0; i != vector2.length(); ++i) {
                if (vector2.isElementNA(i)) {
                    this.conn.writeBytes("NA\n");
                    continue;
                }
                this.out.writeInt(vector2.getElementAsInt(i));
            }
        } else {
            for (int i = 0; i != vector2.length(); ++i) {
                this.out.writeInt(vector2.getElementAsInt(i));
            }
        }
        this.writeAttributes(vector2);
    }

    private void writeDoubleVector(DoubleVector vector2) throws IOException {
        this.writeFlags(14, vector2);
        this.out.writeInt(vector2.length());
        if (this.serializationType == Serialization.SerializationType.ASCII) {
            for (int i = 0; i != vector2.length(); ++i) {
                double d = vector2.getElementAsDouble(i);
                if (!DoubleVector.isFinite(d)) {
                    if (DoubleVector.isNaN(d)) {
                        this.conn.writeBytes("NA\n");
                        continue;
                    }
                    if (d < 0.0) {
                        this.conn.writeBytes("-Inf\n");
                        continue;
                    }
                    this.conn.writeBytes("Inf\n");
                    continue;
                }
                this.out.writeDouble(vector2.getElementAsDouble(i));
            }
        } else {
            for (int i = 0; i != vector2.length(); ++i) {
                if (vector2.isElementNA(i)) {
                    this.out.writeLong(9218868437227407266L);
                    continue;
                }
                this.out.writeDouble(vector2.getElementAsDouble(i));
            }
        }
        this.writeAttributes(vector2);
    }

    private void writeS4(S4Object exp2) throws IOException {
        this.writeFlags(25, exp2);
        this.writeAttributes(exp2);
    }

    private void writeExternalPtr(ExternalPtr exp2) throws IOException {
        this.addRef(exp2);
        this.writeFlags(22, exp2);
        this.writeExp(Null.INSTANCE);
        this.writeExp(Null.INSTANCE);
        this.writeAttributes(exp2);
    }

    private void writeComplexVector(ComplexVector vector2) throws IOException {
        this.writeFlags(15, vector2);
        this.out.writeInt(vector2.length());
        for (int i = 0; i != vector2.length(); ++i) {
            Complex value = vector2.getElementAsComplex(i);
            this.out.writeDouble(value.getReal());
            this.out.writeDouble(value.getImaginary());
        }
        this.writeAttributes(vector2);
    }

    private void writeRawVector(RawVector vector2) throws IOException {
        this.writeFlags(24, vector2);
        this.out.writeInt(vector2.length());
        if (this.serializationType == Serialization.SerializationType.ASCII) {
            byte[] bytes = vector2.toByteArray();
            for (int i = 0; i != vector2.length(); ++i) {
                this.conn.writeBytes(String.format("%02x\n", bytes[i]));
            }
        } else {
            this.out.writeString(vector2.toByteArray());
        }
        this.writeAttributes(vector2);
    }

    private void writeStringVector(StringVector vector2) throws IOException {
        this.writeFlags(16, vector2);
        this.out.writeInt(vector2.length());
        for (int i = 0; i != vector2.length(); ++i) {
            this.writeCharExp(vector2.getElementAsString(i));
        }
        this.writeAttributes(vector2);
    }

    private void writeList(ListVector vector2) throws IOException {
        this.writeFlags(19, vector2);
        this.out.writeInt(vector2.length());
        for (SEXP element : vector2) {
            this.writeExp(element);
        }
        this.writeAttributes(vector2);
    }

    private void writePromise(Promise exp2) throws IOException {
        this.out.writeInt(Flags.computePromiseFlags(exp2));
        this.writeAttributes(exp2);
        if (exp2.getEnvironment() != null) {
            this.writeExp(exp2.getEnvironment());
        }
        this.writeExp(exp2.getValue() == null ? Null.INSTANCE : exp2.getValue());
        this.writeExp(exp2.getExpression());
    }

    private void writePairList(PairList.Node node) throws IOException {
        while (true) {
            this.writeFlags(2, node);
            this.writeAttributes(node);
            this.writeTag(node);
            this.writeExp(node.getValue());
            if (node.getNext() == Null.INSTANCE) break;
            node = node.getNextNode();
        }
        this.writeNull();
    }

    private void writeFunctionCall(FunctionCall exp2) throws IOException {
        this.writeFlags(6, exp2);
        this.writeAttributes(exp2);
        this.writeTag(exp2);
        this.writeExp(exp2.getValue());
        if (exp2.hasNextNode()) {
            this.writeExp(exp2.getNextNode());
        } else {
            this.writeNull();
        }
    }

    private void writeClosure(Closure exp2) throws IOException {
        this.writeFlags(3, exp2);
        this.writeAttributes(exp2);
        this.writeExp(exp2.getEnclosingEnvironment());
        this.writeExp(exp2.getFormals());
        this.writeExp(exp2.getBody());
    }

    private void writeEnvironment(Environment env2) throws IOException {
        if (this.context.isGlobalEnvironment(env2)) {
            this.out.writeInt(253);
        } else if (this.context.isBaseEnvironment(env2)) {
            this.out.writeInt(241);
        } else if (env2 == Environment.EMPTY) {
            this.out.writeInt(242);
        } else if (this.context.isNamespaceEnvironment(env2)) {
            this.writeNamespace(env2);
        } else {
            this.addRef(env2);
            this.writeFlags(4, env2);
            this.out.writeInt(env2.isLocked() ? 1 : 0);
            this.writeExp(env2.getParent());
            this.writeFrame(env2);
            this.writeExp(Null.INSTANCE);
            this.writeExp(env2.getAttributes().asPairList());
        }
    }

    private void writeFrame(Environment exp2) throws IOException {
        for (Symbol name : exp2.getSymbolNames()) {
            if (exp2.isActiveBinding(name)) {
                this.out.writeInt(Flags.computeBindingFlag(true));
                this.writeExp(name);
                this.writeExp(exp2.getActiveBinding(name));
                continue;
            }
            this.out.writeInt(Flags.computeBindingFlag(false));
            this.writeExp(name);
            this.writeExp(exp2.getVariableUnsafe(name));
        }
        this.writeNull();
    }

    private void writeNamespace(Environment ns) throws IOException {
        if (this.context.isBaseNamespaceEnvironment(ns)) {
            this.out.writeInt(250);
        } else {
            this.addRef(ns);
            this.writeFlags(249, ns);
            this.writePersistentNameVector(this.getNamespaceName(ns));
        }
    }

    private boolean tryWriteRef(SEXP exp2) throws IOException {
        if (this.references.containsKey(exp2)) {
            this.writeRefIndex(this.references.get(exp2));
            return true;
        }
        return false;
    }

    private void writeRefIndex(int index) throws IOException {
        if (index > 0x7FFFFF) {
            this.out.writeInt(255);
            this.out.writeInt(index);
        } else {
            this.out.writeInt(0xFF | index << 8);
        }
    }

    private void addRef(SEXP exp2) {
        this.references.put(exp2, this.references.size() + 1);
    }

    private StringVector getNamespaceName(Environment ns) {
        return StringVector.valueOf(this.context.getNamespaceName(ns));
    }

    private void writeSymbol(Symbol symbol2) throws IOException {
        if (symbol2 == Symbol.UNBOUND_VALUE) {
            this.out.writeInt(252);
        } else if (symbol2 == Symbol.MISSING_ARG) {
            this.out.writeInt(251);
        } else {
            this.addRef(symbol2);
            this.writeFlags(1, symbol2);
            this.writeCharExp(symbol2.getPrintName());
        }
    }

    private void writeCharExp(String string) throws IOException {
        if (StringVector.isNA(string)) {
            this.out.writeInt(Flags.computeCharSexpFlags(64));
            this.out.writeInt(-1);
        } else {
            byte[] bytes = string.getBytes(Charsets.UTF_8);
            int encoding = string.length() == bytes.length ? 64 : 8;
            this.out.writeInt(Flags.computeCharSexpFlags(encoding));
            this.out.writeInt(bytes.length);
            this.out.writeString(bytes);
        }
    }

    private void writeAttributes(SEXP exp2) throws IOException {
        PairList attributes2;
        PairList.Builder pairList = exp2.getAttributes().asPairListBuilder();
        if (exp2.getAttributes().isS4()) {
            pairList.add(Flags.OLD_S4_BIT, (SEXP)LogicalVector.TRUE);
        }
        if ((attributes2 = pairList.build()) != Null.INSTANCE) {
            if (!(attributes2 instanceof PairList.Node)) {
                throw new AssertionError(attributes2.getClass());
            }
            this.writeExp(attributes2);
        }
    }

    private void writeTag(PairList.Node node) throws IOException {
        if (node.hasTag()) {
            this.writeExp(node.getTag());
        }
    }

    private void writePrimitive(PrimitiveFunction exp2) throws IOException {
        if (exp2 instanceof BuiltinFunction) {
            this.out.writeInt(8);
        } else {
            this.out.writeInt(7);
        }
        this.out.writeInt(exp2.getName().length());
        this.conn.writeBytes(exp2.getName());
    }

    private void writeFlags(int type, SEXP exp2) throws IOException {
        this.out.writeInt(Flags.computeFlags(exp2, type));
    }

    private static class XdrWriter
    implements StreamWriter {
        private DataOutputStream out;

        private XdrWriter(DataOutputStream out) {
            this.out = out;
        }

        @Override
        public void writeInt(int v) throws IOException {
            this.out.writeInt(v);
        }

        @Override
        public void writeDouble(double d) throws IOException {
            this.out.writeDouble(d);
        }

        @Override
        public void writeLong(long l) throws IOException {
            this.out.writeLong(l);
        }

        @Override
        public void writeString(byte[] bytes) throws IOException {
            this.out.write(bytes);
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    private static class AsciiWriter
    implements StreamWriter {
        private DataOutputStream out;

        private AsciiWriter(DataOutputStream out) {
            this.out = out;
        }

        @Override
        public void writeInt(int v) throws IOException {
            this.out.writeBytes(v + "\n");
        }

        @Override
        public void writeDouble(double d) throws IOException {
            this.out.writeBytes(d + "\n");
        }

        @Override
        public void writeLong(long l) throws IOException {
            this.out.writeBytes(l + "\n");
        }

        @Override
        public void writeString(byte[] bytes) throws IOException {
            for (int i = 0; i < bytes.length; ++i) {
                String s;
                switch (bytes[i]) {
                    case 10: {
                        s = "\\n";
                        break;
                    }
                    case 9: {
                        s = "\\t";
                        break;
                    }
                    case 11: {
                        s = "\\v";
                        break;
                    }
                    case 8: {
                        s = "\\b";
                        break;
                    }
                    case 13: {
                        s = "\\r";
                        break;
                    }
                    case 12: {
                        s = "\\f";
                        break;
                    }
                    case 7: {
                        s = "\\a";
                        break;
                    }
                    case 92: {
                        s = "\\\\";
                        break;
                    }
                    case 127: {
                        s = "\\?";
                        break;
                    }
                    case 39: {
                        s = "\\'";
                        break;
                    }
                    case 34: {
                        s = "\\\"";
                        break;
                    }
                    default: {
                        s = bytes[i] <= 32 || bytes[i] > 126 ? String.format("\\%03o", bytes[i]) : new String(new byte[]{bytes[i]});
                    }
                }
                this.out.writeBytes(s);
            }
            this.out.writeBytes("\n");
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    private static interface StreamWriter
    extends AutoCloseable {
        public void writeInt(int var1) throws IOException;

        public void writeString(byte[] var1) throws IOException;

        public void writeLong(long var1) throws IOException;

        public void writeDouble(double var1) throws IOException;

        @Override
        public void close() throws IOException;
    }

    public static interface PersistenceHook {
        public Vector apply(SEXP var1);
    }
}

