/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.packaging;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.renjin.eval.Context;
import org.renjin.packaging.LazyLoadFrame;
import org.renjin.primitives.io.serialization.RDataReader;
import org.renjin.primitives.packaging.Dataset;
import org.renjin.primitives.packaging.FqPackageName;
import org.renjin.primitives.packaging.Package;
import org.renjin.repackaged.guava.base.Charsets;
import org.renjin.repackaged.guava.base.Function;
import org.renjin.repackaged.guava.base.Strings;
import org.renjin.repackaged.guava.collect.ImmutableList;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.SEXP;

public abstract class FileBasedPackage
extends Package {
    protected FileBasedPackage(FqPackageName name) {
        super(name);
    }

    @Override
    public Iterable<NamedValue> loadSymbols(Context context) throws IOException {
        return LazyLoadFrame.load(context, new Function<String, InputStream>(){

            public InputStream apply(String name) {
                try {
                    return FileBasedPackage.this.getResource(name).openStream();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public abstract boolean resourceExists(String var1);

    private Properties readDatasetIndex() throws IOException {
        Properties datasets = new Properties();
        if (this.resourceExists("datasets")) {
            try (InputStream in = this.getResource("datasets").openStream();){
                datasets.load(in);
            }
        }
        return datasets;
    }

    @Override
    public Collection<String> getPackageDependencies() throws IOException {
        if (this.resourceExists("requires")) {
            ImmutableList lines = this.getResource("requires").asCharSource(Charsets.UTF_8).readLines();
            ArrayList dependencies = Lists.newArrayList();
            for (String line : lines) {
                if (Strings.isNullOrEmpty((String)line)) continue;
                dependencies.add(line);
            }
            return dependencies;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Dataset> getDatasets() {
        try {
            Properties index = this.readDatasetIndex();
            ArrayList datasets = Lists.newArrayList();
            for (String logicalDatasetName : index.stringPropertyNames()) {
                datasets.add(new FileBasedDataset(logicalDatasetName, index.getProperty(logicalDatasetName).split("\\s*,\\s*")));
            }
            return datasets;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class FileBasedDataset
    extends Dataset {
        private String datasetName;
        private Map<String, String> objectNameMap = new HashMap<String, String>();

        public FileBasedDataset(String name, String[] objectNames) {
            this.datasetName = name;
            for (String objectName : objectNames) {
                if (objectName.contains("/")) {
                    String[] parts = objectName.split("/");
                    String member = parts[1];
                    this.objectNameMap.put(member, objectName);
                    continue;
                }
                this.objectNameMap.put(objectName, objectName);
            }
        }

        @Override
        public String getName() {
            return this.datasetName;
        }

        @Override
        public Collection<String> getObjectNames() {
            return this.objectNameMap.keySet();
        }

        @Override
        public SEXP loadObject(String name) throws IOException {
            if (!this.objectNameMap.containsKey(name)) {
                throw new IllegalArgumentException(name);
            }
            try (InputStream in = FileBasedPackage.this.getResource("data/" + this.objectNameMap.get(name)).openStream();){
                RDataReader reader = new RDataReader(in);
                SEXP sEXP = reader.readFile();
                return sEXP;
            }
        }
    }
}

