/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.packaging;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.parser.RParser;
import org.renjin.repackaged.guava.collect.Iterables;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.repackaged.guava.io.CharSource;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

public class NamespaceFile {
    private Map<String, PackageImportEntry> packageImports = Maps.newHashMap();
    private Map<String, JvmClassImportEntry> jvmImports = Maps.newHashMap();
    private List<DynLibEntry> dynLibEntries = Lists.newArrayList();
    private Set<String> exportedPatterns = Sets.newHashSet();
    private Set<Symbol> exportedSymbols = Sets.newHashSet();
    private List<S3MethodEntry> exportedS3Methods = Lists.newArrayList();
    private List<String> exportedS4Methods = Lists.newArrayList();
    private Set<String> exportedClasses = Sets.newHashSet();
    private Set<String> exportedClassPatterns = Sets.newHashSet();

    public static NamespaceFile parse(Context context, CharSource charSource) throws IOException {
        ExpressionVector source;
        NamespaceFile file2 = new NamespaceFile();
        try (Reader reader = charSource.openStream();){
            source = RParser.parseAllSource(reader);
        }
        file2.parse(context, source);
        return file2;
    }

    private NamespaceFile() {
    }

    private PackageImportEntry packageImport(String packageName) {
        PackageImportEntry entry = this.packageImports.get(packageName);
        if (entry == null) {
            entry = new PackageImportEntry(packageName);
            this.packageImports.put(packageName, entry);
        }
        return entry;
    }

    private PackageImportEntry packageImport(SEXP argument) {
        return this.packageImport(NamespaceFile.parseStringArgument(argument));
    }

    private JvmClassImportEntry classImport(String className) {
        JvmClassImportEntry entry = this.jvmImports.get(className);
        if (entry == null) {
            entry = new JvmClassImportEntry(className);
            this.jvmImports.put(className, entry);
        }
        return entry;
    }

    private void parse(Context context, ExpressionVector source) {
        for (SEXP exp2 : source) {
            this.parse(context, exp2);
        }
    }

    private void parse(Context context, SEXP exp2) {
        if (exp2 instanceof ExpressionVector) {
            this.parse(context, (ExpressionVector)exp2);
        } else if (exp2 instanceof FunctionCall) {
            FunctionCall call2 = (FunctionCall)exp2;
            this.parseCall(context, call2);
        } else {
            throw new EvalException("Unknown NAMESPACE directive: " + exp2.toString(), new Object[0]);
        }
    }

    private void parseCall(Context context, FunctionCall call2) {
        String directiveName = NamespaceFile.parseDirectiveName(call2);
        if (directiveName.equals("import")) {
            this.parseImport(call2);
        } else if (directiveName.equals("importClass") || directiveName.equals("importClasses")) {
            this.parseImportClass(call2);
        } else if (directiveName.equals("importFrom")) {
            this.parseImportFrom(call2);
        } else if (directiveName.equals("importFromClass")) {
            this.parseImportFromClass(call2);
        } else if (directiveName.equals("importClassesFrom")) {
            this.parseImportS4ClassesFrom(call2);
        } else if (directiveName.equals("importMethodsFrom")) {
            this.parseImportS4MethodsFrom(call2);
        } else if (directiveName.equals("S3method")) {
            this.parseS3Export(call2);
        } else if (directiveName.equals("export") || directiveName.equals("exports")) {
            this.parseExport(call2);
        } else if (directiveName.equals("exportPattern") || directiveName.equals("exportPatterns")) {
            this.parseExportPattern(call2);
        } else if (directiveName.equals("useDynLib")) {
            this.parseDynlib(call2);
        } else if (directiveName.equals("exportClasses") || directiveName.equals("exportClass")) {
            this.parseExportClasses(call2);
        } else if (directiveName.equals("exportClassPattern") || directiveName.equals("exportClassPatterns")) {
            this.parseExportClassPatterns(call2);
        } else if (directiveName.equals("exportMethods") || directiveName.equals("exportMethod")) {
            this.parseExportMethods(call2);
        } else if (directiveName.equals("if")) {
            this.parseIf(context, call2);
        } else if (directiveName.equals("{")) {
            for (SEXP sexp : call2.getArguments().values()) {
                this.parse(context, sexp);
            }
        } else {
            throw new EvalException("Unknown NAMESPACE directive '" + directiveName + "'", new Object[0]);
        }
    }

    private void parseIf(Context context, FunctionCall call2) {
        Object condition = call2.getArgument(0);
        SEXP evaluatedCondition = context.evaluate((SEXP)condition, context.getBaseEnvironment());
        if (this.isTruthy(evaluatedCondition)) {
            this.parse(context, (SEXP)call2.getArgument(1));
        } else if (call2.getArguments().length() == 3) {
            this.parse(context, (SEXP)call2.getArgument(2));
        }
    }

    private boolean isTruthy(SEXP s) {
        if (s.length() == 0) {
            throw new EvalException("argument is of length zero", new Object[0]);
        }
        Logical logical2 = s.asLogical();
        if (logical2 == Logical.NA) {
            throw new EvalException("missing value where TRUE/FALSE needed", new Object[0]);
        }
        return logical2 == Logical.TRUE;
    }

    private void parseExportPattern(FunctionCall call2) {
        this.exportedPatterns.addAll(NamespaceFile.parseNameArguments(call2));
    }

    private void parseExport(FunctionCall call2) {
        for (SEXP argument : call2.getArguments().values()) {
            this.exportedSymbols.add(NamespaceFile.parseSymbolArgument(argument));
        }
    }

    private void parseImport(FunctionCall call2) {
        for (String packageName : NamespaceFile.parseNameArguments(call2)) {
            this.packageImport(packageName).allSymbols = true;
        }
    }

    private void parseImportFrom(FunctionCall call2) {
        if (call2.getArguments().length() < 1) {
            throw new EvalException("Expected at least one arguments to importFrom directive", new Object[0]);
        }
        PackageImportEntry packageImport = this.packageImport((SEXP)call2.getArgument(0));
        for (int i = 1; i < call2.getArguments().length(); ++i) {
            packageImport.symbols.add(NamespaceFile.parseSymbolArgument(call2.getArgument(i)));
        }
    }

    private void parseImportS4ClassesFrom(FunctionCall call2) {
        if (call2.getArguments().length() < 2) {
            throw new EvalException("Expected at least two arguments to importClassesFrom directive", new Object[0]);
        }
        PackageImportEntry packageImport = this.packageImport((SEXP)call2.getArgument(0));
        for (int i = 1; i < call2.getArguments().length(); ++i) {
            packageImport.classes.add(NamespaceFile.parseStringArgument(call2.getArgument(i)));
        }
    }

    private void parseImportS4MethodsFrom(FunctionCall call2) {
        if (call2.getArguments().length() < 2) {
            throw new EvalException("Expected at least two arguments to importMethodsFrom directive", new Object[0]);
        }
        PackageImportEntry packageImport = this.packageImport((SEXP)call2.getArgument(0));
        for (int i = 1; i < call2.getArguments().length(); ++i) {
            packageImport.methods.add(NamespaceFile.parseStringArgument(call2.getArgument(i)));
        }
    }

    private void parseImportClass(FunctionCall call2) {
        for (String className : NamespaceFile.parseNameArguments(call2)) {
            this.classImport(className).classImported = true;
        }
    }

    private void parseImportFromClass(FunctionCall call2) {
        if (call2.getArguments().length() < 2) {
            throw new EvalException("Expected at least two arguments to importFromClass directive", new Object[0]);
        }
        String className = NamespaceFile.parseStringArgument(call2.getArgument(0));
        JvmClassImportEntry entry = this.classImport(className);
        for (int i = 1; i < call2.getArguments().length(); ++i) {
            String methodName = NamespaceFile.parseStringArgument(call2.getArgument(i));
            entry.methods.add(methodName);
        }
    }

    private static List<String> parseNameArguments(FunctionCall call2) {
        ArrayList names2 = Lists.newArrayList();
        for (SEXP argument : call2.getArguments().values()) {
            names2.add(NamespaceFile.parseStringArgument(argument));
        }
        return names2;
    }

    private static Symbol parseSymbolArgument(SEXP argument) {
        if (argument instanceof Symbol) {
            return (Symbol)argument;
        }
        if (argument instanceof StringVector && argument.length() == 1) {
            return Symbol.get(((StringVector)argument).getElementAsString(0));
        }
        throw new EvalException("Can't parse directive argument '" + argument + "' as symbol", new Object[0]);
    }

    private static String parseStringArgument(SEXP argument) {
        if (argument instanceof StringVector && argument.length() == 1) {
            return ((StringVector)argument).getElementAsString(0);
        }
        if (argument instanceof Symbol) {
            return ((Symbol)argument).getPrintName();
        }
        throw new EvalException("Can't parse directive argument '" + argument + "' as string", new Object[0]);
    }

    private static String parseDirectiveName(FunctionCall call2) {
        if (call2.getFunction() instanceof Symbol) {
            return ((Symbol)call2.getFunction()).getPrintName();
        }
        throw new EvalException("Unknown NAMESPACE directive: " + call2, new Object[0]);
    }

    private void parseS3Export(FunctionCall call2) {
        if (call2.getArguments().length() == 2) {
            if (call2.getArgument(1) == Null.INSTANCE) {
                this.exportedSymbols.add(NamespaceFile.parseSymbolArgument(call2.getArgument(0)));
            } else {
                this.exportedS3Methods.add(new S3MethodEntry(NamespaceFile.parseStringArgument(call2.getArgument(0)), NamespaceFile.parseStringArgument(call2.getArgument(1))));
            }
        } else if (call2.getArguments().length() == 3) {
            this.exportedS3Methods.add(new S3MethodEntry(NamespaceFile.parseStringArgument(call2.getArgument(0)), NamespaceFile.parseStringArgument(call2.getArgument(1)), NamespaceFile.parseStringArgument(call2.getArgument(2))));
        } else {
            throw new UnsupportedOperationException("Expected 2 or 3 arguments to S3Method directive");
        }
    }

    private void parseExportClasses(FunctionCall call2) {
        this.exportedClasses.addAll(NamespaceFile.parseNameArguments(call2));
    }

    private void parseExportClassPatterns(FunctionCall call2) {
        this.exportedClassPatterns.addAll(NamespaceFile.parseNameArguments(call2));
    }

    private void parseExportMethods(FunctionCall call2) {
        this.exportedS4Methods.addAll(NamespaceFile.parseNameArguments(call2));
    }

    private void parseDynlib(FunctionCall call2) {
        if (call2.getArguments().length() < 1) {
            throw new EvalException("Expected at least one argument to useDynlib", new Object[0]);
        }
        DynLibEntry entry = new DynLibEntry();
        entry.libraryName = NamespaceFile.parseStringArgument(call2.getArgument(0));
        for (PairList.Node node : Iterables.skip(call2.getArguments().nodes(), (int)1)) {
            if (node.hasTag()) {
                if (node.getTag().getPrintName().equals(".registration")) {
                    entry.registration = NamespaceFile.parseLogical(node.getValue());
                    continue;
                }
                if (node.getTag().getPrintName().equals(".fixes")) {
                    entry.prefix = NamespaceFile.parseStringArgument(node.getValue());
                    continue;
                }
                entry.symbols.add(new DynLibSymbol(NamespaceFile.parseStringArgument(node.getTag()), NamespaceFile.parseStringArgument(node.getValue())));
                continue;
            }
            entry.symbols.add(new DynLibSymbol(NamespaceFile.parseStringArgument(node.getValue())));
        }
        this.dynLibEntries.add(entry);
    }

    private static boolean parseLogical(SEXP value) {
        if (value instanceof LogicalVector && value.length() == 1) {
            return ((LogicalVector)value).getElementAsRawLogical(0) == 1;
        }
        throw new EvalException("Expected TRUE or FALSE", new Object[0]);
    }

    public Collection<PackageImportEntry> getPackageImports() {
        return this.packageImports.values();
    }

    public Collection<JvmClassImportEntry> getJvmImports() {
        return this.jvmImports.values();
    }

    public List<DynLibEntry> getDynLibEntries() {
        return this.dynLibEntries;
    }

    public Set<String> getExportedPatterns() {
        return this.exportedPatterns;
    }

    public Set<Symbol> getExportedSymbols() {
        return this.exportedSymbols;
    }

    public List<S3MethodEntry> getExportedS3Methods() {
        return this.exportedS3Methods;
    }

    public Set<String> getExportedClasses() {
        return this.exportedClasses;
    }

    public Set<String> getExportedClassPatterns() {
        return this.exportedClassPatterns;
    }

    public List<String> getExportedS4Methods() {
        return this.exportedS4Methods;
    }

    public static class S3MethodEntry {
        private String genericMethod;
        private String className;
        private String functionName;

        private S3MethodEntry(String genericMethod, String className) {
            this.genericMethod = genericMethod;
            this.className = className;
            this.functionName = genericMethod + "." + className;
        }

        private S3MethodEntry(String genericMethod, String className, String functionName) {
            this.genericMethod = genericMethod;
            this.className = className;
            this.functionName = functionName;
        }

        public String getGenericMethod() {
            return this.genericMethod;
        }

        public String getClassName() {
            return this.className;
        }

        public String getFunctionName() {
            return this.functionName;
        }
    }

    public static class JvmClassImportEntry {
        private String className;
        private boolean classImported;
        private Set<String> methods = new HashSet<String>();

        public JvmClassImportEntry(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isClassImported() {
            return this.classImported;
        }

        public Set<String> getMethods() {
            return this.methods;
        }
    }

    public static class PackageImportEntry {
        private String packageName;
        private boolean allSymbols;
        private List<Symbol> symbols = Lists.newArrayList();
        private List<String> classes = Lists.newArrayList();
        private List<String> methods = Lists.newArrayList();

        public PackageImportEntry(String packageName) {
            this.packageName = packageName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public boolean isAllSymbols() {
            return this.allSymbols;
        }

        public List<Symbol> getSymbols() {
            return this.symbols;
        }

        public List<String> getClasses() {
            return this.classes;
        }

        public List<String> getMethods() {
            return this.methods;
        }
    }

    public static class DynLibSymbol {
        private String alias;
        private String symbolName;
        private String fixes;

        private DynLibSymbol(String alias, String symbolName) {
            this.alias = alias;
            this.symbolName = symbolName;
        }

        private DynLibSymbol(String symbolName) {
            this.symbolName = symbolName;
            this.alias = symbolName;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getSymbolName() {
            return this.symbolName;
        }
    }

    public static class DynLibEntry {
        private String libraryName;
        private String prefix = "";
        private boolean registration;
        private List<DynLibSymbol> symbols = new ArrayList<DynLibSymbol>();

        public String getLibraryName() {
            return this.libraryName;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean isRegistration() {
            return this.registration;
        }

        public List<DynLibSymbol> getSymbols() {
            return this.symbols;
        }
    }
}

