/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.packaging;

import java.io.IOException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.Unevaluated;
import org.renjin.primitives.packaging.Namespace;
import org.renjin.primitives.packaging.NamespaceFrame;
import org.renjin.primitives.packaging.NamespaceRegistry;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class Namespaces {
    @Internal
    public static SEXP getRegisteredNamespace(@Current Context context, @Current NamespaceRegistry registry, SEXP nameSexp) {
        Symbol name;
        if (nameSexp instanceof Symbol) {
            name = (Symbol)nameSexp;
            if (".GlobalEnv".equals(name.getPrintName())) {
                return Null.INSTANCE;
            }
        } else if (nameSexp instanceof StringVector) {
            name = Symbol.get(nameSexp.asString());
        } else {
            throw new EvalException("Illegal type of argument name: '%s'", nameSexp.getTypeName());
        }
        if (registry.isRegistered(name)) {
            return registry.getNamespace(context, name).getNamespaceEnvironment();
        }
        return Null.INSTANCE;
    }

    @Internal
    public static Environment getNamespaceRegistry(@Current NamespaceRegistry registry) {
        return Environment.createChildEnvironment(Environment.EMPTY, new NamespaceFrame(registry)).build();
    }

    @Builtin
    public static SEXP getNamespace(@Current Context context, @Current NamespaceRegistry registry, Symbol name) {
        Namespace namespace = registry.getNamespace(context, name);
        Environment namespaceEnv = namespace.getNamespaceEnvironment();
        return namespaceEnv;
    }

    @Builtin
    public static SEXP getNamespace(@Current Context context, @Current NamespaceRegistry registry, String name) {
        Namespace namespace = registry.getNamespace(context, name);
        Environment namespaceEnv = namespace.getNamespaceEnvironment();
        return namespaceEnv;
    }

    @Builtin
    public static boolean isNamespace(@Current NamespaceRegistry registry, SEXP envExp) {
        if (envExp instanceof Environment) {
            return registry.isNamespaceEnv((Environment)envExp);
        }
        return false;
    }

    @Builtin
    public static StringVector loadedNamespaces(@Current NamespaceRegistry registry) {
        StringVector.Builder result = new StringVector.Builder();
        for (Symbol name : registry.getLoadedNamespaces()) {
            result.add(name.getPrintName());
        }
        return result.build();
    }

    @Builtin(value=":::")
    public static SEXP getNamespaceValue(@Current Context context, @Current NamespaceRegistry registry, @Unevaluated Symbol namespace, @Unevaluated Symbol entry) {
        return registry.getNamespace(context, namespace).getEntry(entry).force(context);
    }

    @Builtin(value="::")
    public static SEXP getExportedNamespaceValue(@Current Context context, @Current NamespaceRegistry registry, @Unevaluated Symbol namespace, @Unevaluated Symbol entry) {
        return registry.getNamespace(context, namespace).getExport(entry).force(context);
    }

    @Internal
    public static SEXP getDataset(@Current Context context, @Current NamespaceRegistry registry, String namespaceName, String datasetName) throws IOException {
        return registry.getNamespace(context, namespaceName).getPackage().getDataset(datasetName);
    }

    private static Namespace resolveNamespace(Context context, NamespaceRegistry registry, SEXP sexp) {
        if (sexp instanceof Environment) {
            Environment environment2 = (Environment)sexp;
            if (registry.isNamespaceEnv(environment2)) {
                return registry.getNamespace(environment2);
            }
        } else if (sexp instanceof StringVector && sexp.length() == 1) {
            return registry.getNamespace(context, ((StringVector)sexp).getElementAsString(0));
        }
        throw new EvalException("Error in argument " + sexp + " : not a namespace", new Object[0]);
    }

    @Builtin
    public static StringVector getNamespaceName(@Current Context context, @Current NamespaceRegistry registry, SEXP envExp) {
        Namespace namespace = Namespaces.resolveNamespace(context, registry, envExp);
        if (namespace == registry.getBaseNamespace()) {
            return new StringArrayVector("base");
        }
        StringVector.Builder builder = StringArrayVector.newBuilder();
        builder.add(namespace.getCompatibleName());
        builder.setAttribute(Symbols.NAMES, (SEXP)StringArrayVector.valueOf("name"));
        return builder.build();
    }

    @Builtin
    public static StringVector getNamespaceExports(@Current Context context, @Current NamespaceRegistry registry, SEXP sexp) {
        Namespace ns = Namespaces.resolveNamespace(context, registry, sexp);
        StringVector.Builder result = new StringVector.Builder();
        for (Symbol name : ns.getExports()) {
            result.add(name.getPrintName());
        }
        return result.build();
    }

    @Builtin
    public static StringVector getNamespaceImports(@Current Context context, @Current NamespaceRegistry registry, SEXP sexp) {
        Namespace ns = Namespaces.resolveNamespace(context, registry, sexp);
        throw new UnsupportedOperationException("TODO: implement getNamespaceImports!");
    }

    @Internal(value="find.package")
    public static StringVector findPackage(@Current Context context, AtomicVector packageNames) throws FileSystemException {
        StringVector.Builder result = new StringVector.Builder();
        for (int i = 0; i < packageNames.length(); ++i) {
            String packageName = packageNames.getElementAsString(i);
            Namespace namespace = context.getNamespaceRegistry().getNamespace(context, packageName);
            FileObject fileObject = namespace.getPackage().resolvePackageRoot(context.getFileSystemManager());
            result.add(fileObject.getURL().toString());
        }
        return result.build();
    }
}

