/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.special;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.S3;
import org.renjin.primitives.special.DollarFunction;
import org.renjin.primitives.subset.Subsetting;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

public class DollarAssignFunction
extends SpecialFunction {
    public DollarAssignFunction() {
        super("$<-");
    }

    @Override
    public SEXP apply(Context context, Environment rho, FunctionCall call2, PairList args2) {
        if (args2.length() != 3) {
            throw new EvalException(String.format("%d argument(s) passed to '$<-' which requires 3", args2.length()), new Object[0]);
        }
        SEXP object2 = context.evaluate((SEXP)args2.getElementAsSEXP(0), rho);
        StringVector nameArgument = DollarFunction.evaluateName(args2.getElementAsSEXP(1));
        SEXP value = context.evaluate((SEXP)args2.getElementAsSEXP(2), rho);
        PairList.Node repackagedArgs = new PairList.Node(object2, new PairList.Node(nameArgument, new PairList.Node(Symbol.get("value"), value, Null.INSTANCE)));
        SEXP genericResult = S3.tryDispatchFromPrimitive(context, rho, call2, "$<-", object2, repackagedArgs);
        if (genericResult != null) {
            return genericResult;
        }
        String name = nameArgument.getElementAsString(0);
        if (object2 instanceof PairList.Node) {
            return Subsetting.setElementByName((PairList.Node)object2, name, value);
        }
        if (object2 instanceof Environment) {
            return Subsetting.setElementByName(context, (Environment)object2, name, value);
        }
        if (object2 instanceof ListVector) {
            return Subsetting.setElementByName((ListVector)object2, name, value);
        }
        if (object2 instanceof ExternalPtr) {
            return Subsetting.setElementByName((ExternalPtr)object2, name, value);
        }
        if (object2 instanceof AtomicVector) {
            return Subsetting.setElementByName((AtomicVector)object2, name, value);
        }
        throw new EvalException("object of type '%s' is not subsettable", object2.getTypeName());
    }
}

