/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.special;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.primitives.S3;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

public class DollarFunction
extends SpecialFunction {
    public DollarFunction() {
        super("$");
    }

    @Override
    public SEXP apply(Context context, Environment rho, FunctionCall call2, PairList args2) {
        StringVector nameArgument;
        PairList.Node repackagedArgs;
        if (args2.length() != 2) {
            throw new EvalException(String.format("%d argument(s) passed to '$' which requires 2", args2.length()), new Object[0]);
        }
        SEXP object2 = context.evaluate((SEXP)args2.getElementAsSEXP(0), rho);
        SEXP genericResult = S3.tryDispatchFromPrimitive(context, rho, call2, "$", object2, repackagedArgs = new PairList.Node(object2, new PairList.Node(nameArgument = DollarFunction.evaluateName(args2.getElementAsSEXP(1)), Null.INSTANCE)));
        if (genericResult != null) {
            return genericResult;
        }
        String name = nameArgument.getElementAsString(0);
        if (object2 instanceof PairList) {
            return DollarFunction.fromPairList((PairList)object2, name);
        }
        if (object2 instanceof Environment) {
            return DollarFunction.fromEnvironment(context, (Environment)object2, name);
        }
        if (object2 instanceof ListVector) {
            return DollarFunction.fromList((ListVector)object2, name);
        }
        if (object2 instanceof ExternalPtr) {
            return DollarFunction.fromExternalPtr((ExternalPtr)object2, name);
        }
        if (object2 instanceof AtomicVector) {
            throw new EvalException("$ operator is invalid for atomic vectors", new Object[0]);
        }
        throw new EvalException("object of type '%s' is not subsettable", object2.getTypeName());
    }

    static StringVector evaluateName(SEXP name) {
        if (name instanceof Symbol) {
            return new StringArrayVector(((Symbol)name).getPrintName());
        }
        if (name instanceof StringVector) {
            return (StringVector)name;
        }
        throw new EvalException("invalid subscript type '%s'", name.getTypeName());
    }

    public static SEXP fromPairList(PairList list2, String name) {
        SEXP match2 = null;
        int matchCount = 0;
        for (PairList.Node node : list2.nodes()) {
            if (!node.hasTag() || !node.getTag().getPrintName().startsWith(name)) continue;
            match2 = node.getValue();
            ++matchCount;
        }
        return matchCount == 1 ? match2 : Null.INSTANCE;
    }

    public static SEXP fromEnvironment(@Current Context context, Environment env2, String name) {
        SEXP value = env2.getVariable(context, name);
        if (value == Symbol.UNBOUND_VALUE) {
            return Null.INSTANCE;
        }
        return value;
    }

    public static SEXP fromExternalPtr(ExternalPtr<?> externalPtr, String name) {
        return externalPtr.getMember(Symbol.get(name));
    }

    public static SEXP fromList(ListVector list2, String name) {
        SEXP match2 = null;
        int matchCount = 0;
        for (int i = 0; i != list2.length(); ++i) {
            String elementName = list2.getName(i);
            if (StringVector.isNA(elementName)) continue;
            if (elementName.equals(name)) {
                return list2.getElementAsSEXP(i);
            }
            if (!elementName.startsWith(name)) continue;
            match2 = list2.get(i);
            ++matchCount;
        }
        return matchCount == 1 ? match2 : Null.INSTANCE;
    }
}

