/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.special;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.Primitives;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.Symbol;

public class InternalFunction
extends SpecialFunction {
    public InternalFunction() {
        super(".Internal");
    }

    @Override
    public SEXP apply(Context context, Environment rho, FunctionCall call2, PairList args2) {
        Object arg = call2.getArgument(0);
        assert (arg != null);
        if (!(arg instanceof FunctionCall)) {
            throw new EvalException("invalid .Internal() argument", new Object[0]);
        }
        FunctionCall internalCall = (FunctionCall)arg;
        Symbol internalName = (Symbol)internalCall.getFunction();
        PrimitiveFunction function2 = Primitives.getInternal(internalName);
        if (function2 == null || function2 == Null.INSTANCE) {
            throw new EvalException(String.format("no internal function \"%s\"", internalName.getPrintName()), new Object[0]);
        }
        return ((Function)function2).apply(context, rho, internalCall, internalCall.getArguments());
    }
}

