/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import java.util.List;
import org.renjin.eval.EvalException;
import org.renjin.primitives.subset.CompleteSelection;
import org.renjin.primitives.subset.CoordinateMatrixSelection;
import org.renjin.primitives.subset.LogicalSelection;
import org.renjin.primitives.subset.MatrixSelection;
import org.renjin.primitives.subset.NamedSelection;
import org.renjin.primitives.subset.NullSelection;
import org.renjin.primitives.subset.SelectionStrategy;
import org.renjin.primitives.subset.VectorIndexSelection;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;

class Selections {
    Selections() {
    }

    public static SelectionStrategy parseSelection(SEXP source, List<SEXP> subscripts) {
        if (subscripts.size() == 0) {
            return new CompleteSelection();
        }
        if (subscripts.size() > 1) {
            return new MatrixSelection(subscripts);
        }
        SEXP subscript = subscripts.get(0);
        if (subscript == Symbol.MISSING_ARG) {
            return new CompleteSelection();
        }
        if (CoordinateMatrixSelection.isCoordinateMatrix(source, subscript)) {
            return new CoordinateMatrixSelection((AtomicVector)subscript);
        }
        if (subscript instanceof LogicalVector) {
            return new LogicalSelection((LogicalVector)subscript);
        }
        if (subscript instanceof StringVector) {
            return new NamedSelection((StringVector)subscript);
        }
        if (subscript instanceof DoubleVector || subscript instanceof IntVector) {
            return new VectorIndexSelection((AtomicVector)subscript);
        }
        if (subscript == Null.INSTANCE) {
            return NullSelection.INSTANCE;
        }
        throw new EvalException("invalid subscript type '%s'", subscript.getTypeName());
    }

    public static SelectionStrategy parseSingleSelection(SEXP source, List<SEXP> subscripts) {
        if (subscripts.size() == 0) {
            throw new EvalException("[[ operator requires at least one subscript", new Object[0]);
        }
        if (subscripts.size() > 1) {
            return new MatrixSelection(subscripts);
        }
        int dimCount = source.getAttributes().getDim().length();
        SEXP subscript = subscripts.get(0);
        if (subscript == Symbol.MISSING_ARG) {
            throw new EvalException("[[ operator requires at least one subscript", new Object[0]);
        }
        if (dimCount == 1) {
            return new MatrixSelection(subscripts);
        }
        if (subscript instanceof StringVector) {
            return new NamedSelection((StringVector)subscript);
        }
        if (subscript instanceof DoubleVector || subscript instanceof IntVector || subscript instanceof LogicalVector) {
            return new VectorIndexSelection((AtomicVector)subscript);
        }
        if (subscript == Null.INSTANCE) {
            return NullSelection.INSTANCE;
        }
        throw new EvalException("invalid subscript type '%s'", subscript.getTypeName());
    }
}

