/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.Iterator;
import org.apache.commons.math.complex.Complex;
import org.renjin.parser.NumericLiterals;
import org.renjin.primitives.vector.ConvertingComplexVector;
import org.renjin.repackaged.guava.collect.UnmodifiableIterator;
import org.renjin.sexp.AbstractAtomicVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ComplexArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public abstract class ComplexVector
extends AbstractAtomicVector
implements Iterable<Complex> {
    public static final String TYPE_NAME = "complex";
    public static final ComplexVector EMPTY = new ComplexArrayVector(new Complex[0]);
    public static final ComplexVector NAMED_EMPTY = new ComplexArrayVector(new Complex[0], AttributeMap.builder().setNames(StringVector.EMPTY).build());
    public static final Complex NA = new Complex(DoubleVector.NA, DoubleVector.NA);
    public static final Complex NaN = new Complex(Double.NaN, Double.NaN);
    public static final Vector.Type VECTOR_TYPE = new ComplexType();

    public static Complex complex(double real2) {
        if (DoubleVector.isNA(real2)) {
            return NA;
        }
        return ComplexVector.complex(real2, 0.0);
    }

    public static Complex complex(double real2, double imaginary) {
        return new Complex(real2, imaginary);
    }

    public Complex[] toComplexArray() {
        Complex[] complexNumbers = new Complex[this.length()];
        for (int i = 0; i < this.length(); ++i) {
            complexNumbers[i] = this.getElementAsComplex(i);
        }
        return complexNumbers;
    }

    public static ComplexVector valueOf(Complex value) {
        return new ComplexArrayVector(value);
    }

    public static ComplexVector valueOf(double real2) {
        return new ComplexArrayVector(ComplexVector.complex(real2));
    }

    public ComplexVector() {
    }

    public ComplexVector(AttributeMap attributes2) {
        super(attributes2);
    }

    public static boolean isNA(Complex value) {
        return DoubleVector.isNA(value.getReal());
    }

    public static boolean isNaN(Complex value) {
        return Double.isNaN(value.getReal());
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public void accept(SexpVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public abstract int length();

    @Override
    public abstract Complex getElementAsComplex(int var1);

    public double getElementAsComplexIm(int index) {
        return this.getElementAsComplex(index).getImaginary();
    }

    public SEXP getElementAsSEXP(int index) {
        return new ComplexArrayVector(this.getElementAsComplex(index));
    }

    @Override
    public Comparable getElementAsObject(int index) {
        throw new UnsupportedOperationException("how can Complex not implement Comparable!!!");
    }

    @Override
    public double getElementAsDouble(int index) {
        return this.getElementAsComplex(index).getReal();
    }

    @Override
    public int getElementAsInt(int index) {
        double value = this.getElementAsDouble(index);
        return DoubleVector.isNA(value) ? Integer.MIN_VALUE : (int)value;
    }

    @Override
    public String getElementAsString(int index) {
        return NumericLiterals.toString(this.getElementAsComplex(index));
    }

    @Override
    public int getElementAsRawLogical(int index) {
        double value = this.getElementAsDouble(index);
        if (value == 0.0) {
            return 0;
        }
        if (DoubleVector.isNA(value)) {
            return Integer.MIN_VALUE;
        }
        return 1;
    }

    @Override
    public Vector.Builder newBuilderWithInitialSize(int initialSize) {
        return new ComplexArrayVector.Builder(initialSize);
    }

    @Override
    public Vector.Builder newBuilderWithInitialCapacity(int initialCapacity) {
        return ComplexArrayVector.Builder.withInitialCapacity(initialCapacity);
    }

    @Override
    public Vector.Builder newCopyBuilder() {
        return new ComplexArrayVector.Builder(this);
    }

    @Override
    public boolean isElementNA(int index) {
        return ComplexVector.isNA(this.getElementAsComplex(index));
    }

    @Override
    public boolean isElementNaN(int index) {
        double real2 = this.getElementAsComplex(index).getReal();
        return Double.isNaN(real2);
    }

    @Override
    public Vector.Type getVectorType() {
        return VECTOR_TYPE;
    }

    @Override
    public int compare(int index1, int index2) {
        throw new UnsupportedOperationException("implement me");
    }

    @Override
    public int indexOf(AtomicVector vector2, int vectorIndex, int startIndex) {
        Complex value = vector2.getElementAsComplex(vectorIndex);
        for (int i = startIndex; i < this.length(); ++i) {
            Complex match2 = this.getElementAsComplex(i);
            if (!DoubleVector.match(value.getReal(), match2.getReal()) || !DoubleVector.match(value.getImaginary(), match2.getImaginary())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<Complex> iterator() {
        return new UnmodifiableIterator<Complex>(){
            private int index = 0;

            public boolean hasNext() {
                return this.index < ComplexVector.this.length();
            }

            public Complex next() {
                return ComplexVector.this.getElementAsComplex(this.index++);
            }
        };
    }

    private static class ComplexType
    extends Vector.Type {
        public ComplexType() {
            super(5);
        }

        @Override
        public ComplexArrayVector.Builder newBuilder() {
            return new ComplexArrayVector.Builder(0, 0);
        }

        @Override
        public ComplexArrayVector.Builder newBuilderWithInitialSize(int length2) {
            return new ComplexArrayVector.Builder(length2);
        }

        @Override
        public ComplexArrayVector.Builder newBuilderWithInitialCapacity(int initialCapacity) {
            return new ComplexArrayVector.Builder(0, initialCapacity);
        }

        @Override
        public int compareElements(Vector vector1, int index1, Vector vector2, int index2) {
            throw new UnsupportedOperationException("invalid comparison with complex values");
        }

        @Override
        public boolean elementsEqual(Vector vector1, int index1, Vector vector2, int index2) {
            return vector1.getElementAsComplex(index1).equals((Object)vector2.getElementAsComplex(index2));
        }

        @Override
        public Vector to(Vector x) {
            if (x instanceof ComplexVector) {
                return x;
            }
            return new ConvertingComplexVector(x, x.getAttributes());
        }

        @Override
        public Vector getElementAsVector(Vector vector2, int index) {
            return new ComplexArrayVector(vector2.getElementAsComplex(index));
        }
    }
}

