/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.renjin.primitives.matrix.Matrix;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;
import org.renjin.stats.internals.models.ModelMatrixColumn;
import org.renjin.stats.internals.models.MultivariateColumn;
import org.renjin.stats.internals.models.UnivariateColumn;
import org.renjin.stats.internals.models.Variable;

public class NumericVariable
extends Variable {
    private final String name;
    private final Vector vector;
    private final int numColumns;

    public NumericVariable(String name, SEXP vector2) {
        this.name = name;
        this.vector = (Vector)vector2;
        Vector dim2 = vector2.getAttributes().getDim();
        if (dim2.length() < 2) {
            this.numColumns = 1;
        } else if (dim2.length() == 2) {
            this.numColumns = dim2.getElementAsInt(1);
        } else {
            throw new UnsupportedOperationException("variable " + name + " has " + dim2.length() + " dimensions, don't know what to do");
        }
    }

    @Override
    public List<? extends ModelMatrixColumn> getModelMatrixColumns() {
        if (this.numColumns == 1) {
            return Collections.singletonList(new UnivariateColumn(this.name, this.vector));
        }
        ArrayList columns = Lists.newArrayList();
        for (int i = 0; i != this.numColumns; ++i) {
            columns.add(new MultivariateColumn(this.name + "." + (i + 1), new Matrix(this.vector, this.numColumns), i));
        }
        return columns;
    }
}

