/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.models;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.renjin.primitives.Deparse;
import org.renjin.repackaged.guava.collect.Iterators;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.SEXP;

public class Term
implements Iterable<SEXP> {
    private List<SEXP> expressions;

    public Term(SEXP ... expressions) {
        this.expressions = Lists.newArrayList((Object[])expressions);
    }

    public Term(Iterable<SEXP> expressions) {
        this.expressions = Lists.newArrayList(expressions);
    }

    public Term(Term a, Term b) {
        this.expressions = Lists.newArrayList();
        this.expressions.addAll(a.getExpressions());
        this.expressions.addAll(b.getExpressions());
    }

    public Collection<SEXP> getExpressions() {
        return Collections.unmodifiableCollection(this.expressions);
    }

    public int getOrder() {
        return this.expressions.size();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expressions == null ? 0 : this.expressions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Term other = (Term)obj;
        return this.expressions.equals(other.expressions);
    }

    public String toString() {
        return "Term(" + this.getLabel() + ")";
    }

    public String getLabel() {
        String varNames = Deparse.deparseExp(null, this.expressions.get(0));
        if (this.expressions.size() > 1) {
            for (int i = 1; i < this.expressions.size(); ++i) {
                varNames = varNames.concat(":").concat(Deparse.deparseExp(null, this.expressions.get(i)));
            }
        } else {
            return varNames;
        }
        return varNames;
    }

    @Override
    public Iterator<SEXP> iterator() {
        return Iterators.unmodifiableIterator(this.expressions.iterator());
    }
}

