/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.optimize;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.MultivariateRealFunction;
import org.renjin.eval.Context;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Vector;

public class MultivariateRealClosure
implements MultivariateRealFunction {
    private Context context;
    private Environment rho;
    private Function fn;
    private double scale = 1.0;

    public MultivariateRealClosure(Context context, Environment rho, Function fn) {
        this.context = context;
        this.rho = rho;
        this.fn = fn;
    }

    public void setFunctionScale(double scale) {
        this.scale = scale;
    }

    public double value(double[] x) throws FunctionEvaluationException, IllegalArgumentException {
        FunctionCall call2 = FunctionCall.newCall(this.fn, new DoubleArrayVector(x));
        Vector y = (Vector)this.context.evaluate(call2, this.rho);
        return y.getElementAsDouble(0) / this.scale;
    }
}

