/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.util;

import java.util.ArrayList;
import java.util.Collection;
import org.renjin.eval.EvalException;
import org.renjin.invoke.reflection.ClassBindingImpl;
import org.renjin.invoke.reflection.MemberBinding;
import org.renjin.invoke.reflection.PropertyBinding;
import org.renjin.invoke.reflection.converters.AtomicVectorConverter;
import org.renjin.invoke.reflection.converters.BooleanConverter;
import org.renjin.invoke.reflection.converters.Converter;
import org.renjin.invoke.reflection.converters.EnumConverter;
import org.renjin.invoke.reflection.converters.StringConverter;
import org.renjin.primitives.vector.RowNamesVector;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class DataFrameBuilder {
    public static ListVector build(ExternalPtr externalPointer) {
        if (externalPointer.getInstance() instanceof Collection) {
            Collection collection = (Collection)externalPointer.getInstance();
            if (collection.isEmpty()) {
                throw new EvalException("Cannot create data.frame from an empty list.", new Object[0]);
            }
            Class<?> itemClass = collection.iterator().next().getClass();
            return DataFrameBuilder.build(itemClass, collection);
        }
        throw new EvalException("Unsupported class: " + externalPointer.getInstance().getClass().getName(), new Object[0]);
    }

    public static <T> ListVector build(Class<T> beanClass, Collection<T> rows) {
        int numRows = rows.size();
        ArrayList<Column> columns = new ArrayList<Column>();
        ClassBindingImpl classBinding = ClassBindingImpl.get(beanClass);
        for (Symbol symbol2 : classBinding.getMembers()) {
            MemberBinding memberBinding = classBinding.getMemberBinding(symbol2);
            if (!(memberBinding instanceof PropertyBinding)) continue;
            PropertyBinding property = (PropertyBinding)memberBinding;
            Converter converter = property.getConverter();
            if (converter instanceof StringConverter) {
                columns.add(new StringColumn(property, numRows));
                continue;
            }
            if (converter instanceof BooleanConverter) {
                columns.add(new BooleanColumn(property, numRows));
                continue;
            }
            if (converter instanceof EnumConverter) {
                columns.add(new EnumColumn(property, numRows));
                continue;
            }
            if (!(converter instanceof AtomicVectorConverter)) continue;
            columns.add(new NumberColumn(property, numRows));
        }
        for (Symbol row2 : rows) {
            for (Column column : columns) {
                column.add(row2);
            }
        }
        ListVector.NamedBuilder list2 = new ListVector.NamedBuilder();
        for (Column column : columns) {
            list2.add(column.getName(), (SEXP)column.build());
        }
        list2.setAttribute(Symbols.ROW_NAMES, (SEXP)new RowNamesVector(numRows));
        list2.setAttribute(Symbols.CLASS, (SEXP)StringArrayVector.valueOf("data.frame"));
        return list2.build();
    }

    private static class BooleanColumn
    extends Column {
        private LogicalArrayVector.Builder builder;

        public BooleanColumn(PropertyBinding propertyBinding, int length2) {
            super(propertyBinding, length2);
        }

        @Override
        public void init(int length2) {
            this.builder = new LogicalArrayVector.Builder(0, length2);
        }

        @Override
        public void add(Object instance) {
            Boolean value = (Boolean)this.propertyBinding.getRawValue(instance);
            if (value == null) {
                this.builder.addNA();
            } else {
                this.builder.add(value);
            }
        }

        @Override
        public Vector build() {
            return this.builder.build();
        }
    }

    private static class EnumColumn
    extends Column {
        private StringVector.Builder builder;

        public EnumColumn(PropertyBinding propertyBinding, int length2) {
            super(propertyBinding, length2);
        }

        @Override
        public void init(int length2) {
            this.builder = new StringVector.Builder(0, length2);
        }

        @Override
        public void add(Object instance) {
            Enum rawValue = (Enum)this.propertyBinding.getRawValue(instance);
            this.builder.add(rawValue.name());
        }

        @Override
        public Vector build() {
            return this.builder.build();
        }
    }

    private static class NumberColumn
    extends Column {
        private Vector.Builder builder;

        public NumberColumn(PropertyBinding propertyBinding, int length2) {
            super(propertyBinding, length2);
        }

        @Override
        public void init(int length2) {
            this.builder = this.converter.getVectorType().newBuilderWithInitialCapacity(length2);
        }

        @Override
        public void add(Object instance) {
            Number value = (Number)this.propertyBinding.getRawValue(instance);
            if (value == null) {
                this.builder.addNA();
            } else {
                this.builder.add(value);
            }
        }

        @Override
        public Vector build() {
            return this.builder.build();
        }
    }

    private static class StringColumn
    extends Column {
        private StringVector.Builder builder;

        public StringColumn(PropertyBinding propertyBinding, int length2) {
            super(propertyBinding, length2);
        }

        @Override
        public void init(int length2) {
            this.builder = new StringVector.Builder(0, length2);
        }

        @Override
        public void add(Object instance) {
            this.builder.add((String)this.propertyBinding.getRawValue(instance));
        }

        @Override
        public Vector build() {
            return this.builder.build();
        }
    }

    private static abstract class Column {
        protected final PropertyBinding propertyBinding;
        protected final AtomicVectorConverter converter;

        public Column(PropertyBinding propertyBinding, int length2) {
            this.propertyBinding = propertyBinding;
            this.converter = (AtomicVectorConverter)((Object)propertyBinding.getConverter());
            this.init(length2);
        }

        public String getName() {
            return this.propertyBinding.getName().getPrintName();
        }

        public abstract void init(int var1);

        public abstract void add(Object var1);

        public abstract Vector build();
    }
}

