/*
 * Decompiled with CFR 0.152.
 */
package org.structr.csv;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.structr.schema.action.ActionContext;
import org.structr.web.function.UiFunction;

public class FromCsvFunction
extends UiFunction {
    public static final String ERROR_MESSAGE_FROM_CSV = "Usage: ${from_csv(source[, delimiterChar[, quoteChar[, recordSeparator[, header]]]])}. Example: ${from_csv('COL1;COL2;COL3\none;two;three')}";
    public static final String ERROR_MESSAGE_FROM_CSV_JS = "Usage: ${{Structr.from_csv(source[, delimiterChar[, quoteChar[, recordSeparator[, header]]]])}}. Example: ${{Structr.from_csv('COL1;COL2;COL3\none;two;three')}}";

    public String getName() {
        return "from_csv()";
    }

    public Object apply(ActionContext ctx, Object caller, Object[] sources) {
        if (this.arrayHasMinLengthAndMaxLengthAndAllElementsNotNull(sources, 1, 5)) {
            try {
                LinkedList<Map> objects = new LinkedList<Map>();
                String source = sources[0].toString();
                String delimiter = ";";
                String quoteChar = "\"";
                String recordSeparator = "\n";
                boolean customColumnNamesSupplied = false;
                switch (sources.length) {
                    case 5: {
                        customColumnNamesSupplied = sources[4] instanceof Collection;
                    }
                    case 4: {
                        recordSeparator = (String)sources[3];
                    }
                    case 3: {
                        quoteChar = (String)sources[2];
                    }
                    case 2: {
                        delimiter = (String)sources[1];
                    }
                }
                CSVFormat format = CSVFormat.newFormat((char)delimiter.charAt(0));
                format = customColumnNamesSupplied ? format.withHeader(((Collection)sources[4]).toArray(new String[0])).withSkipHeaderRecord(false) : format.withHeader(new String[0]).withSkipHeaderRecord(true);
                format = format.withQuote(quoteChar.charAt(0));
                format = format.withRecordSeparator(recordSeparator);
                format = format.withIgnoreEmptyLines(true);
                format = format.withIgnoreSurroundingSpaces(true);
                format = format.withQuoteMode(QuoteMode.ALL);
                CSVParser parser = new CSVParser((Reader)new StringReader(source), format);
                for (CSVRecord record : parser.getRecords()) {
                    objects.add(record.toMap());
                }
                return objects;
            }
            catch (Throwable t) {
                this.logException(t, "{}: Exception for parameter: {}", new Object[]{this.getName(), this.getParametersAsString(sources)});
                return "";
            }
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return this.usage(ctx.isJavaScriptContext());
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_FROM_CSV_JS : ERROR_MESSAGE_FROM_CSV;
    }

    public String shortDescription() {
        return "Parses the given CSV string and returns a list objects";
    }
}

